/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAutoScalingConfigurationsResponse extends AppRunnerResponse implements
        ToCopyableBuilder<ListAutoScalingConfigurationsResponse.Builder, ListAutoScalingConfigurationsResponse> {
    private static final SdkField<List<AutoScalingConfigurationSummary>> AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD = SdkField
            .<List<AutoScalingConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("AutoScalingConfigurationSummaryList")
            .getter(getter(ListAutoScalingConfigurationsResponse::autoScalingConfigurationSummaryList))
            .setter(setter(Builder::autoScalingConfigurationSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("AutoScalingConfigurationSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoScalingConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoScalingConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAutoScalingConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList;

    private final String nextToken;

    private ListAutoScalingConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfigurationSummaryList = builder.autoScalingConfigurationSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoScalingConfigurationSummaryList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAutoScalingConfigurationSummaryList() {
        return autoScalingConfigurationSummaryList != null
                && !(autoScalingConfigurationSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of summary information records for auto scaling configurations. In a paginated request, the request
     * returns up to <code>MaxResults</code> records for each call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoScalingConfigurationSummaryList}
     * method.
     * </p>
     * 
     * @return A list of summary information records for auto scaling configurations. In a paginated request, the
     *         request returns up to <code>MaxResults</code> records for each call.
     */
    public final List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList() {
        return autoScalingConfigurationSummaryList;
    }

    /**
     * <p>
     * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
     * request.
     * </p>
     * 
     * @return The token that you can pass in a subsequent request to get the next result page. It's returned in a
     *         paginated request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAutoScalingConfigurationSummaryList() ? autoScalingConfigurationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAutoScalingConfigurationsResponse)) {
            return false;
        }
        ListAutoScalingConfigurationsResponse other = (ListAutoScalingConfigurationsResponse) obj;
        return hasAutoScalingConfigurationSummaryList() == other.hasAutoScalingConfigurationSummaryList()
                && Objects.equals(autoScalingConfigurationSummaryList(), other.autoScalingConfigurationSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListAutoScalingConfigurationsResponse")
                .add("AutoScalingConfigurationSummaryList",
                        hasAutoScalingConfigurationSummaryList() ? autoScalingConfigurationSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfigurationSummaryList":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingConfigurationSummaryList", AUTO_SCALING_CONFIGURATION_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAutoScalingConfigurationsResponse, T> g) {
        return obj -> g.apply((ListAutoScalingConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppRunnerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAutoScalingConfigurationsResponse> {
        /**
         * <p>
         * A list of summary information records for auto scaling configurations. In a paginated request, the request
         * returns up to <code>MaxResults</code> records for each call.
         * </p>
         * 
         * @param autoScalingConfigurationSummaryList
         *        A list of summary information records for auto scaling configurations. In a paginated request, the
         *        request returns up to <code>MaxResults</code> records for each call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationSummaryList(
                Collection<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList);

        /**
         * <p>
         * A list of summary information records for auto scaling configurations. In a paginated request, the request
         * returns up to <code>MaxResults</code> records for each call.
         * </p>
         * 
         * @param autoScalingConfigurationSummaryList
         *        A list of summary information records for auto scaling configurations. In a paginated request, the
         *        request returns up to <code>MaxResults</code> records for each call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationSummaryList(AutoScalingConfigurationSummary... autoScalingConfigurationSummaryList);

        /**
         * <p>
         * A list of summary information records for auto scaling configurations. In a paginated request, the request
         * returns up to <code>MaxResults</code> records for each call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #autoScalingConfigurationSummaryList(List<AutoScalingConfigurationSummary>)}.
         * 
         * @param autoScalingConfigurationSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingConfigurationSummaryList(java.util.Collection<AutoScalingConfigurationSummary>)
         */
        Builder autoScalingConfigurationSummaryList(
                Consumer<AutoScalingConfigurationSummary.Builder>... autoScalingConfigurationSummaryList);

        /**
         * <p>
         * The token that you can pass in a subsequent request to get the next result page. It's returned in a paginated
         * request.
         * </p>
         * 
         * @param nextToken
         *        The token that you can pass in a subsequent request to get the next result page. It's returned in a
         *        paginated request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppRunnerResponse.BuilderImpl implements Builder {
        private List<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAutoScalingConfigurationsResponse model) {
            super(model);
            autoScalingConfigurationSummaryList(model.autoScalingConfigurationSummaryList);
            nextToken(model.nextToken);
        }

        public final List<AutoScalingConfigurationSummary.Builder> getAutoScalingConfigurationSummaryList() {
            List<AutoScalingConfigurationSummary.Builder> result = AutoScalingConfigurationSummaryListCopier
                    .copyToBuilder(this.autoScalingConfigurationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingConfigurationSummaryList(
                Collection<AutoScalingConfigurationSummary.BuilderImpl> autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList = AutoScalingConfigurationSummaryListCopier
                    .copyFromBuilder(autoScalingConfigurationSummaryList);
        }

        @Override
        public final Builder autoScalingConfigurationSummaryList(
                Collection<AutoScalingConfigurationSummary> autoScalingConfigurationSummaryList) {
            this.autoScalingConfigurationSummaryList = AutoScalingConfigurationSummaryListCopier
                    .copy(autoScalingConfigurationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingConfigurationSummaryList(
                AutoScalingConfigurationSummary... autoScalingConfigurationSummaryList) {
            autoScalingConfigurationSummaryList(Arrays.asList(autoScalingConfigurationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingConfigurationSummaryList(
                Consumer<AutoScalingConfigurationSummary.Builder>... autoScalingConfigurationSummaryList) {
            autoScalingConfigurationSummaryList(Stream.of(autoScalingConfigurationSummaryList)
                    .map(c -> AutoScalingConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAutoScalingConfigurationsResponse build() {
            return new ListAutoScalingConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
