/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the runtime configuration of an App Runner service instance (scaling unit).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceConfiguration.Builder, InstanceConfiguration> {
    private static final SdkField<String> CPU_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cpu")
            .getter(getter(InstanceConfiguration::cpu)).setter(setter(Builder::cpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cpu").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Memory")
            .getter(getter(InstanceConfiguration::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRoleArn").getter(getter(InstanceConfiguration::instanceRoleArn))
            .setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CPU_FIELD, MEMORY_FIELD,
            INSTANCE_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cpu;

    private final String memory;

    private final String instanceRoleArn;

    private InstanceConfiguration(BuilderImpl builder) {
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.instanceRoleArn = builder.instanceRoleArn;
    }

    /**
     * <p>
     * The number of CPU units reserved for each instance of your App Runner service.
     * </p>
     * <p>
     * Default: <code>1 vCPU</code>
     * </p>
     * 
     * @return The number of CPU units reserved for each instance of your App Runner service.</p>
     *         <p>
     *         Default: <code>1 vCPU</code>
     */
    public final String cpu() {
        return cpu;
    }

    /**
     * <p>
     * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
     * </p>
     * <p>
     * Default: <code>2 GB</code>
     * </p>
     * 
     * @return The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
     *         <p>
     *         Default: <code>2 GB</code>
     */
    public final String memory() {
        return memory;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are
     * permissions that your code needs when it calls any Amazon Web Services APIs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These
     *         are permissions that your code needs when it calls any Amazon Web Services APIs.
     */
    public final String instanceRoleArn() {
        return instanceRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cpu());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceConfiguration)) {
            return false;
        }
        InstanceConfiguration other = (InstanceConfiguration) obj;
        return Objects.equals(cpu(), other.cpu()) && Objects.equals(memory(), other.memory())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceConfiguration").add("Cpu", cpu()).add("Memory", memory())
                .add("InstanceRoleArn", instanceRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cpu":
            return Optional.ofNullable(clazz.cast(cpu()));
        case "Memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cpu", CPU_FIELD);
        map.put("Memory", MEMORY_FIELD);
        map.put("InstanceRoleArn", INSTANCE_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceConfiguration, T> g) {
        return obj -> g.apply((InstanceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceConfiguration> {
        /**
         * <p>
         * The number of CPU units reserved for each instance of your App Runner service.
         * </p>
         * <p>
         * Default: <code>1 vCPU</code>
         * </p>
         * 
         * @param cpu
         *        The number of CPU units reserved for each instance of your App Runner service.</p>
         *        <p>
         *        Default: <code>1 vCPU</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpu(String cpu);

        /**
         * <p>
         * The amount of memory, in MB or GB, reserved for each instance of your App Runner service.
         * </p>
         * <p>
         * Default: <code>2 GB</code>
         * </p>
         * 
         * @param memory
         *        The amount of memory, in MB or GB, reserved for each instance of your App Runner service.</p>
         *        <p>
         *        Default: <code>2 GB</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service. These are
         * permissions that your code needs when it calls any Amazon Web Services APIs.
         * </p>
         * 
         * @param instanceRoleArn
         *        The Amazon Resource Name (ARN) of an IAM role that provides permissions to your App Runner service.
         *        These are permissions that your code needs when it calls any Amazon Web Services APIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String cpu;

        private String memory;

        private String instanceRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceConfiguration model) {
            cpu(model.cpu);
            memory(model.memory);
            instanceRoleArn(model.instanceRoleArn);
        }

        public final String getCpu() {
            return cpu;
        }

        public final void setCpu(String cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(String cpu) {
            this.cpu = cpu;
            return this;
        }

        public final String getMemory() {
            return memory;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        @Override
        public InstanceConfiguration build() {
            return new InstanceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
