/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about an App Runner automatic scaling configuration resource.
 * </p>
 * <p>
 * This type contains limited information about an auto scaling configuration. It includes only identification
 * information, without configuration details. It's returned by the <a>ListAutoScalingConfigurations</a> action.
 * Complete configuration information is returned by the <a>CreateAutoScalingConfiguration</a>,
 * <a>DescribeAutoScalingConfiguration</a>, and <a>DeleteAutoScalingConfiguration</a> actions using the
 * <a>AutoScalingConfiguration</a> type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingConfigurationSummary.Builder, AutoScalingConfigurationSummary> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationArn")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationArn))
            .setter(setter(Builder::autoScalingConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn")
                    .build()).build();

    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingConfigurationName")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationName))
            .setter(setter(Builder::autoScalingConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationName")
                    .build()).build();

    private static final SdkField<Integer> AUTO_SCALING_CONFIGURATION_REVISION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutoScalingConfigurationRevision")
            .getter(getter(AutoScalingConfigurationSummary::autoScalingConfigurationRevision))
            .setter(setter(Builder::autoScalingConfigurationRevision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationRevision")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AutoScalingConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(AutoScalingConfigurationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Boolean> HAS_ASSOCIATED_SERVICE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasAssociatedService").getter(getter(AutoScalingConfigurationSummary::hasAssociatedService))
            .setter(setter(Builder::hasAssociatedService))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAssociatedService").build())
            .build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(AutoScalingConfigurationSummary::isDefault))
            .setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTO_SCALING_CONFIGURATION_ARN_FIELD, AUTO_SCALING_CONFIGURATION_NAME_FIELD,
            AUTO_SCALING_CONFIGURATION_REVISION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, HAS_ASSOCIATED_SERVICE_FIELD,
            IS_DEFAULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autoScalingConfigurationArn;

    private final String autoScalingConfigurationName;

    private final Integer autoScalingConfigurationRevision;

    private final String status;

    private final Instant createdAt;

    private final Boolean hasAssociatedService;

    private final Boolean isDefault;

    private AutoScalingConfigurationSummary(BuilderImpl builder) {
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.autoScalingConfigurationName = builder.autoScalingConfigurationName;
        this.autoScalingConfigurationRevision = builder.autoScalingConfigurationRevision;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.hasAssociatedService = builder.hasAssociatedService;
        this.isDefault = builder.isDefault;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of this auto scaling configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of this auto scaling configuration.
     */
    public final String autoScalingConfigurationArn() {
        return autoScalingConfigurationArn;
    }

    /**
     * <p>
     * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a configuration.
     * </p>
     * 
     * @return The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
     *         configuration.
     */
    public final String autoScalingConfigurationName() {
        return autoScalingConfigurationName;
    }

    /**
     * <p>
     * The revision of this auto scaling configuration. It's unique among all the active configurations (
     * <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
     * </p>
     * 
     * @return The revision of this auto scaling configuration. It's unique among all the active configurations (
     *         <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
     */
    public final Integer autoScalingConfigurationRevision() {
        return autoScalingConfigurationRevision;
    }

    /**
     * <p>
     * The current state of the auto scaling configuration. If the status of a configuration revision is
     * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed
     * some time after they are deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutoScalingConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the auto scaling configuration. If the status of a configuration revision is
     *         <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
     *         removed some time after they are deleted.
     * @see AutoScalingConfigurationStatus
     */
    public final AutoScalingConfigurationStatus status() {
        return AutoScalingConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the auto scaling configuration. If the status of a configuration revision is
     * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently removed
     * some time after they are deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutoScalingConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the auto scaling configuration. If the status of a configuration revision is
     *         <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
     *         removed some time after they are deleted.
     * @see AutoScalingConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time when the auto scaling configuration was created. It's in Unix time stamp format.
     * </p>
     * 
     * @return The time when the auto scaling configuration was created. It's in Unix time stamp format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of
     * <code>true</code> indicates one or more services are associated. A value of <code>false</code> indicates no
     * services are associated.
     * </p>
     * 
     * @return Indicates if this auto scaling configuration has an App Runner service associated with it. A value of
     *         <code>true</code> indicates one or more services are associated. A value of <code>false</code> indicates
     *         no services are associated.
     */
    public final Boolean hasAssociatedService() {
        return hasAssociatedService;
    }

    /**
     * <p>
     * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that does
     * not have an auto scaling configuration ARN specified during creation. Each account can have only one default
     * <code>AutoScalingConfiguration</code> per region. The default <code>AutoScalingConfiguration</code> can be any
     * revision under the same <code>AutoScalingConfigurationName</code>.
     * </p>
     * 
     * @return Indicates if this auto scaling configuration should be used as the default for a new App Runner service
     *         that does not have an auto scaling configuration ARN specified during creation. Each account can have
     *         only one default <code>AutoScalingConfiguration</code> per region. The default
     *         <code>AutoScalingConfiguration</code> can be any revision under the same
     *         <code>AutoScalingConfigurationName</code>.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingConfigurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedService());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfigurationSummary)) {
            return false;
        }
        AutoScalingConfigurationSummary other = (AutoScalingConfigurationSummary) obj;
        return Objects.equals(autoScalingConfigurationArn(), other.autoScalingConfigurationArn())
                && Objects.equals(autoScalingConfigurationName(), other.autoScalingConfigurationName())
                && Objects.equals(autoScalingConfigurationRevision(), other.autoScalingConfigurationRevision())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(hasAssociatedService(), other.hasAssociatedService())
                && Objects.equals(isDefault(), other.isDefault());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingConfigurationSummary")
                .add("AutoScalingConfigurationArn", autoScalingConfigurationArn())
                .add("AutoScalingConfigurationName", autoScalingConfigurationName())
                .add("AutoScalingConfigurationRevision", autoScalingConfigurationRevision()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("HasAssociatedService", hasAssociatedService()).add("IsDefault", isDefault())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingConfigurationArn":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationArn()));
        case "AutoScalingConfigurationName":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationName()));
        case "AutoScalingConfigurationRevision":
            return Optional.ofNullable(clazz.cast(autoScalingConfigurationRevision()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "HasAssociatedService":
            return Optional.ofNullable(clazz.cast(hasAssociatedService()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoScalingConfigurationArn", AUTO_SCALING_CONFIGURATION_ARN_FIELD);
        map.put("AutoScalingConfigurationName", AUTO_SCALING_CONFIGURATION_NAME_FIELD);
        map.put("AutoScalingConfigurationRevision", AUTO_SCALING_CONFIGURATION_REVISION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("HasAssociatedService", HAS_ASSOCIATED_SERVICE_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfigurationSummary, T> g) {
        return obj -> g.apply((AutoScalingConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingConfigurationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of this auto scaling configuration.
         * </p>
         * 
         * @param autoScalingConfigurationArn
         *        The Amazon Resource Name (ARN) of this auto scaling configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationArn(String autoScalingConfigurationArn);

        /**
         * <p>
         * The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
         * configuration.
         * </p>
         * 
         * @param autoScalingConfigurationName
         *        The customer-provided auto scaling configuration name. It can be used in multiple revisions of a
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationName(String autoScalingConfigurationName);

        /**
         * <p>
         * The revision of this auto scaling configuration. It's unique among all the active configurations (
         * <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
         * </p>
         * 
         * @param autoScalingConfigurationRevision
         *        The revision of this auto scaling configuration. It's unique among all the active configurations (
         *        <code>"Status": "ACTIVE"</code>) with the same <code>AutoScalingConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision);

        /**
         * <p>
         * The current state of the auto scaling configuration. If the status of a configuration revision is
         * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
         * removed some time after they are deleted.
         * </p>
         * 
         * @param status
         *        The current state of the auto scaling configuration. If the status of a configuration revision is
         *        <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are
         *        permanently removed some time after they are deleted.
         * @see AutoScalingConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the auto scaling configuration. If the status of a configuration revision is
         * <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are permanently
         * removed some time after they are deleted.
         * </p>
         * 
         * @param status
         *        The current state of the auto scaling configuration. If the status of a configuration revision is
         *        <code>INACTIVE</code>, it was deleted and can't be used. Inactive configuration revisions are
         *        permanently removed some time after they are deleted.
         * @see AutoScalingConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingConfigurationStatus
         */
        Builder status(AutoScalingConfigurationStatus status);

        /**
         * <p>
         * The time when the auto scaling configuration was created. It's in Unix time stamp format.
         * </p>
         * 
         * @param createdAt
         *        The time when the auto scaling configuration was created. It's in Unix time stamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Indicates if this auto scaling configuration has an App Runner service associated with it. A value of
         * <code>true</code> indicates one or more services are associated. A value of <code>false</code> indicates no
         * services are associated.
         * </p>
         * 
         * @param hasAssociatedService
         *        Indicates if this auto scaling configuration has an App Runner service associated with it. A value of
         *        <code>true</code> indicates one or more services are associated. A value of <code>false</code>
         *        indicates no services are associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasAssociatedService(Boolean hasAssociatedService);

        /**
         * <p>
         * Indicates if this auto scaling configuration should be used as the default for a new App Runner service that
         * does not have an auto scaling configuration ARN specified during creation. Each account can have only one
         * default <code>AutoScalingConfiguration</code> per region. The default <code>AutoScalingConfiguration</code>
         * can be any revision under the same <code>AutoScalingConfigurationName</code>.
         * </p>
         * 
         * @param isDefault
         *        Indicates if this auto scaling configuration should be used as the default for a new App Runner
         *        service that does not have an auto scaling configuration ARN specified during creation. Each account
         *        can have only one default <code>AutoScalingConfiguration</code> per region. The default
         *        <code>AutoScalingConfiguration</code> can be any revision under the same
         *        <code>AutoScalingConfigurationName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);
    }

    static final class BuilderImpl implements Builder {
        private String autoScalingConfigurationArn;

        private String autoScalingConfigurationName;

        private Integer autoScalingConfigurationRevision;

        private String status;

        private Instant createdAt;

        private Boolean hasAssociatedService;

        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfigurationSummary model) {
            autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            autoScalingConfigurationName(model.autoScalingConfigurationName);
            autoScalingConfigurationRevision(model.autoScalingConfigurationRevision);
            status(model.status);
            createdAt(model.createdAt);
            hasAssociatedService(model.hasAssociatedService);
            isDefault(model.isDefault);
        }

        public final String getAutoScalingConfigurationArn() {
            return autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final String getAutoScalingConfigurationName() {
            return autoScalingConfigurationName;
        }

        public final void setAutoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
        }

        @Override
        public final Builder autoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
            return this;
        }

        public final Integer getAutoScalingConfigurationRevision() {
            return autoScalingConfigurationRevision;
        }

        public final void setAutoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
        }

        @Override
        public final Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoScalingConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getHasAssociatedService() {
            return hasAssociatedService;
        }

        public final void setHasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
        }

        @Override
        public final Builder hasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        public AutoScalingConfigurationSummary build() {
            return new AutoScalingConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
