/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apprunner.model.RuntimeEnvironmentSecretsCopier;
import software.amazon.awssdk.services.apprunner.model.RuntimeEnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageConfiguration> {
    private static final SdkField<Map<String, String>> RUNTIME_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuntimeEnvironmentVariables").getter(ImageConfiguration.getter(ImageConfiguration::runtimeEnvironmentVariables)).setter(ImageConfiguration.setter(Builder::runtimeEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> START_COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartCommand").getter(ImageConfiguration.getter(ImageConfiguration::startCommand)).setter(ImageConfiguration.setter(Builder::startCommand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartCommand").build()}).build();
    private static final SdkField<String> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Port").getter(ImageConfiguration.getter(ImageConfiguration::port)).setter(ImageConfiguration.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Map<String, String>> RUNTIME_ENVIRONMENT_SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RuntimeEnvironmentSecrets").getter(ImageConfiguration.getter(ImageConfiguration::runtimeEnvironmentSecrets)).setter(ImageConfiguration.setter(Builder::runtimeEnvironmentSecrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeEnvironmentSecrets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_ENVIRONMENT_VARIABLES_FIELD, START_COMMAND_FIELD, PORT_FIELD, RUNTIME_ENVIRONMENT_SECRETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> runtimeEnvironmentVariables;
    private final String startCommand;
    private final String port;
    private final Map<String, String> runtimeEnvironmentSecrets;

    private ImageConfiguration(BuilderImpl builder) {
        this.runtimeEnvironmentVariables = builder.runtimeEnvironmentVariables;
        this.startCommand = builder.startCommand;
        this.port = builder.port;
        this.runtimeEnvironmentSecrets = builder.runtimeEnvironmentSecrets;
    }

    public final boolean hasRuntimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables != null && !(this.runtimeEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> runtimeEnvironmentVariables() {
        return this.runtimeEnvironmentVariables;
    }

    public final String startCommand() {
        return this.startCommand;
    }

    public final String port() {
        return this.port;
    }

    public final boolean hasRuntimeEnvironmentSecrets() {
        return this.runtimeEnvironmentSecrets != null && !(this.runtimeEnvironmentSecrets instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> runtimeEnvironmentSecrets() {
        return this.runtimeEnvironmentSecrets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeEnvironmentVariables() ? this.runtimeEnvironmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startCommand());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuntimeEnvironmentSecrets() ? this.runtimeEnvironmentSecrets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageConfiguration)) {
            return false;
        }
        ImageConfiguration other = (ImageConfiguration)obj;
        return this.hasRuntimeEnvironmentVariables() == other.hasRuntimeEnvironmentVariables() && Objects.equals(this.runtimeEnvironmentVariables(), other.runtimeEnvironmentVariables()) && Objects.equals(this.startCommand(), other.startCommand()) && Objects.equals(this.port(), other.port()) && this.hasRuntimeEnvironmentSecrets() == other.hasRuntimeEnvironmentSecrets() && Objects.equals(this.runtimeEnvironmentSecrets(), other.runtimeEnvironmentSecrets());
    }

    public final String toString() {
        return ToString.builder((String)"ImageConfiguration").add("RuntimeEnvironmentVariables", (Object)(this.runtimeEnvironmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("StartCommand", (Object)(this.startCommand() == null ? null : "*** Sensitive Data Redacted ***")).add("Port", (Object)this.port()).add("RuntimeEnvironmentSecrets", (Object)(this.runtimeEnvironmentSecrets() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuntimeEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentVariables()));
            }
            case "StartCommand": {
                return Optional.ofNullable(clazz.cast(this.startCommand()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "RuntimeEnvironmentSecrets": {
                return Optional.ofNullable(clazz.cast(this.runtimeEnvironmentSecrets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuntimeEnvironmentVariables", RUNTIME_ENVIRONMENT_VARIABLES_FIELD);
        map.put("StartCommand", START_COMMAND_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("RuntimeEnvironmentSecrets", RUNTIME_ENVIRONMENT_SECRETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageConfiguration, T> g) {
        return obj -> g.apply((ImageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> runtimeEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private String startCommand;
        private String port;
        private Map<String, String> runtimeEnvironmentSecrets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageConfiguration model) {
            this.runtimeEnvironmentVariables(model.runtimeEnvironmentVariables);
            this.startCommand(model.startCommand);
            this.port(model.port);
            this.runtimeEnvironmentSecrets(model.runtimeEnvironmentSecrets);
        }

        public final Map<String, String> getRuntimeEnvironmentVariables() {
            if (this.runtimeEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runtimeEnvironmentVariables;
        }

        public final void setRuntimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = RuntimeEnvironmentVariablesCopier.copy(runtimeEnvironmentVariables);
        }

        @Override
        public final Builder runtimeEnvironmentVariables(Map<String, String> runtimeEnvironmentVariables) {
            this.runtimeEnvironmentVariables = RuntimeEnvironmentVariablesCopier.copy(runtimeEnvironmentVariables);
            return this;
        }

        public final String getStartCommand() {
            return this.startCommand;
        }

        public final void setStartCommand(String startCommand) {
            this.startCommand = startCommand;
        }

        @Override
        public final Builder startCommand(String startCommand) {
            this.startCommand = startCommand;
            return this;
        }

        public final String getPort() {
            return this.port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final Map<String, String> getRuntimeEnvironmentSecrets() {
            if (this.runtimeEnvironmentSecrets instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.runtimeEnvironmentSecrets;
        }

        public final void setRuntimeEnvironmentSecrets(Map<String, String> runtimeEnvironmentSecrets) {
            this.runtimeEnvironmentSecrets = RuntimeEnvironmentSecretsCopier.copy(runtimeEnvironmentSecrets);
        }

        @Override
        public final Builder runtimeEnvironmentSecrets(Map<String, String> runtimeEnvironmentSecrets) {
            this.runtimeEnvironmentSecrets = RuntimeEnvironmentSecretsCopier.copy(runtimeEnvironmentSecrets);
            return this;
        }

        public ImageConfiguration build() {
            return new ImageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageConfiguration> {
        public Builder runtimeEnvironmentVariables(Map<String, String> var1);

        public Builder startCommand(String var1);

        public Builder port(String var1);

        public Builder runtimeEnvironmentSecrets(Map<String, String> var1);
    }
}

