/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.CodeConfiguration;
import software.amazon.awssdk.services.apprunner.model.SourceCodeVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeRepository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeRepository> {
    private static final SdkField<String> REPOSITORY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepositoryUrl").getter(CodeRepository.getter(CodeRepository::repositoryUrl)).setter(CodeRepository.setter(Builder::repositoryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryUrl").build()}).build();
    private static final SdkField<SourceCodeVersion> SOURCE_CODE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceCodeVersion").getter(CodeRepository.getter(CodeRepository::sourceCodeVersion)).setter(CodeRepository.setter(Builder::sourceCodeVersion)).constructor(SourceCodeVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeVersion").build()}).build();
    private static final SdkField<CodeConfiguration> CODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeConfiguration").getter(CodeRepository.getter(CodeRepository::codeConfiguration)).setter(CodeRepository.setter(Builder::codeConfiguration)).constructor(CodeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeConfiguration").build()}).build();
    private static final SdkField<String> SOURCE_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceDirectory").getter(CodeRepository.getter(CodeRepository::sourceDirectory)).setter(CodeRepository.setter(Builder::sourceDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDirectory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_URL_FIELD, SOURCE_CODE_VERSION_FIELD, CODE_CONFIGURATION_FIELD, SOURCE_DIRECTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeRepository.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String repositoryUrl;
    private final SourceCodeVersion sourceCodeVersion;
    private final CodeConfiguration codeConfiguration;
    private final String sourceDirectory;

    private CodeRepository(BuilderImpl builder) {
        this.repositoryUrl = builder.repositoryUrl;
        this.sourceCodeVersion = builder.sourceCodeVersion;
        this.codeConfiguration = builder.codeConfiguration;
        this.sourceDirectory = builder.sourceDirectory;
    }

    public final String repositoryUrl() {
        return this.repositoryUrl;
    }

    public final SourceCodeVersion sourceCodeVersion() {
        return this.sourceCodeVersion;
    }

    public final CodeConfiguration codeConfiguration() {
        return this.codeConfiguration;
    }

    public final String sourceDirectory() {
        return this.sourceDirectory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDirectory());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeRepository)) {
            return false;
        }
        CodeRepository other = (CodeRepository)obj;
        return Objects.equals(this.repositoryUrl(), other.repositoryUrl()) && Objects.equals(this.sourceCodeVersion(), other.sourceCodeVersion()) && Objects.equals(this.codeConfiguration(), other.codeConfiguration()) && Objects.equals(this.sourceDirectory(), other.sourceDirectory());
    }

    public final String toString() {
        return ToString.builder((String)"CodeRepository").add("RepositoryUrl", (Object)this.repositoryUrl()).add("SourceCodeVersion", (Object)this.sourceCodeVersion()).add("CodeConfiguration", (Object)this.codeConfiguration()).add("SourceDirectory", (Object)this.sourceDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryUrl": {
                return Optional.ofNullable(clazz.cast(this.repositoryUrl()));
            }
            case "SourceCodeVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeVersion()));
            }
            case "CodeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.codeConfiguration()));
            }
            case "SourceDirectory": {
                return Optional.ofNullable(clazz.cast(this.sourceDirectory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RepositoryUrl", REPOSITORY_URL_FIELD);
        map.put("SourceCodeVersion", SOURCE_CODE_VERSION_FIELD);
        map.put("CodeConfiguration", CODE_CONFIGURATION_FIELD);
        map.put("SourceDirectory", SOURCE_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeRepository, T> g) {
        return obj -> g.apply((CodeRepository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryUrl;
        private SourceCodeVersion sourceCodeVersion;
        private CodeConfiguration codeConfiguration;
        private String sourceDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeRepository model) {
            this.repositoryUrl(model.repositoryUrl);
            this.sourceCodeVersion(model.sourceCodeVersion);
            this.codeConfiguration(model.codeConfiguration);
            this.sourceDirectory(model.sourceDirectory);
        }

        public final String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        public final void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Override
        public final Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public final SourceCodeVersion.Builder getSourceCodeVersion() {
            return this.sourceCodeVersion != null ? this.sourceCodeVersion.toBuilder() : null;
        }

        public final void setSourceCodeVersion(SourceCodeVersion.BuilderImpl sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion != null ? sourceCodeVersion.build() : null;
        }

        @Override
        public final Builder sourceCodeVersion(SourceCodeVersion sourceCodeVersion) {
            this.sourceCodeVersion = sourceCodeVersion;
            return this;
        }

        public final CodeConfiguration.Builder getCodeConfiguration() {
            return this.codeConfiguration != null ? this.codeConfiguration.toBuilder() : null;
        }

        public final void setCodeConfiguration(CodeConfiguration.BuilderImpl codeConfiguration) {
            this.codeConfiguration = codeConfiguration != null ? codeConfiguration.build() : null;
        }

        @Override
        public final Builder codeConfiguration(CodeConfiguration codeConfiguration) {
            this.codeConfiguration = codeConfiguration;
            return this;
        }

        public final String getSourceDirectory() {
            return this.sourceDirectory;
        }

        public final void setSourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public final Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        public CodeRepository build() {
            return new CodeRepository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeRepository> {
        public Builder repositoryUrl(String var1);

        public Builder sourceCodeVersion(SourceCodeVersion var1);

        default public Builder sourceCodeVersion(Consumer<SourceCodeVersion.Builder> sourceCodeVersion) {
            return this.sourceCodeVersion((SourceCodeVersion)((SourceCodeVersion.Builder)SourceCodeVersion.builder().applyMutation(sourceCodeVersion)).build());
        }

        public Builder codeConfiguration(CodeConfiguration var1);

        default public Builder codeConfiguration(Consumer<CodeConfiguration.Builder> codeConfiguration) {
            return this.codeConfiguration((CodeConfiguration)((CodeConfiguration.Builder)CodeConfiguration.builder().applyMutation(codeConfiguration)).build());
        }

        public Builder sourceDirectory(String var1);
    }
}

