/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAutoScalingConfigurationRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, DeleteAutoScalingConfigurationRequest> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationArn").getter(DeleteAutoScalingConfigurationRequest.getter(DeleteAutoScalingConfigurationRequest::autoScalingConfigurationArn)).setter(DeleteAutoScalingConfigurationRequest.setter(Builder::autoScalingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn").build()}).build();
    private static final SdkField<Boolean> DELETE_ALL_REVISIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteAllRevisions").getter(DeleteAutoScalingConfigurationRequest.getter(DeleteAutoScalingConfigurationRequest::deleteAllRevisions)).setter(DeleteAutoScalingConfigurationRequest.setter(Builder::deleteAllRevisions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteAllRevisions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_CONFIGURATION_ARN_FIELD, DELETE_ALL_REVISIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAutoScalingConfigurationRequest.memberNameToFieldInitializer();
    private final String autoScalingConfigurationArn;
    private final Boolean deleteAllRevisions;

    private DeleteAutoScalingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.deleteAllRevisions = builder.deleteAllRevisions;
    }

    public final String autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }

    public final Boolean deleteAllRevisions() {
        return this.deleteAllRevisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteAllRevisions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAutoScalingConfigurationRequest)) {
            return false;
        }
        DeleteAutoScalingConfigurationRequest other = (DeleteAutoScalingConfigurationRequest)((Object)obj);
        return Objects.equals(this.autoScalingConfigurationArn(), other.autoScalingConfigurationArn()) && Objects.equals(this.deleteAllRevisions(), other.deleteAllRevisions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAutoScalingConfigurationRequest").add("AutoScalingConfigurationArn", (Object)this.autoScalingConfigurationArn()).add("DeleteAllRevisions", (Object)this.deleteAllRevisions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationArn()));
            }
            case "DeleteAllRevisions": {
                return Optional.ofNullable(clazz.cast(this.deleteAllRevisions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AutoScalingConfigurationArn", AUTO_SCALING_CONFIGURATION_ARN_FIELD);
        map.put("DeleteAllRevisions", DELETE_ALL_REVISIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAutoScalingConfigurationRequest, T> g) {
        return obj -> g.apply((DeleteAutoScalingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String autoScalingConfigurationArn;
        private Boolean deleteAllRevisions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAutoScalingConfigurationRequest model) {
            super(model);
            this.autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            this.deleteAllRevisions(model.deleteAllRevisions);
        }

        public final String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final Boolean getDeleteAllRevisions() {
            return this.deleteAllRevisions;
        }

        public final void setDeleteAllRevisions(Boolean deleteAllRevisions) {
            this.deleteAllRevisions = deleteAllRevisions;
        }

        @Override
        public final Builder deleteAllRevisions(Boolean deleteAllRevisions) {
            this.deleteAllRevisions = deleteAllRevisions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAutoScalingConfigurationRequest build() {
            return new DeleteAutoScalingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAutoScalingConfigurationRequest> {
        public Builder autoScalingConfigurationArn(String var1);

        public Builder deleteAllRevisions(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

