/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceCodeVersionType {
    BRANCH("BRANCH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceCodeVersionType> VALUE_MAP;
    private final String value;

    private SourceCodeVersionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceCodeVersionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceCodeVersionType> knownValues() {
        EnumSet<SourceCodeVersionType> knownValues = EnumSet.allOf(SourceCodeVersionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceCodeVersionType.class, SourceCodeVersionType::toString);
    }
}

