/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.IngressVpcConfiguration;
import software.amazon.awssdk.services.apprunner.model.VpcIngressConnectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcIngressConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcIngressConnection> {
    private static final SdkField<String> VPC_INGRESS_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcIngressConnectionArn").getter(VpcIngressConnection.getter(VpcIngressConnection::vpcIngressConnectionArn)).setter(VpcIngressConnection.setter(Builder::vpcIngressConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionArn").build()}).build();
    private static final SdkField<String> VPC_INGRESS_CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcIngressConnectionName").getter(VpcIngressConnection.getter(VpcIngressConnection::vpcIngressConnectionName)).setter(VpcIngressConnection.setter(Builder::vpcIngressConnectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcIngressConnectionName").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(VpcIngressConnection.getter(VpcIngressConnection::serviceArn)).setter(VpcIngressConnection.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(VpcIngressConnection.getter(VpcIngressConnection::statusAsString)).setter(VpcIngressConnection.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(VpcIngressConnection.getter(VpcIngressConnection::accountId)).setter(VpcIngressConnection.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(VpcIngressConnection.getter(VpcIngressConnection::domainName)).setter(VpcIngressConnection.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<IngressVpcConfiguration> INGRESS_VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngressVpcConfiguration").getter(VpcIngressConnection.getter(VpcIngressConnection::ingressVpcConfiguration)).setter(VpcIngressConnection.setter(Builder::ingressVpcConfiguration)).constructor(IngressVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressVpcConfiguration").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(VpcIngressConnection.getter(VpcIngressConnection::createdAt)).setter(VpcIngressConnection.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletedAt").getter(VpcIngressConnection.getter(VpcIngressConnection::deletedAt)).setter(VpcIngressConnection.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_INGRESS_CONNECTION_ARN_FIELD, VPC_INGRESS_CONNECTION_NAME_FIELD, SERVICE_ARN_FIELD, STATUS_FIELD, ACCOUNT_ID_FIELD, DOMAIN_NAME_FIELD, INGRESS_VPC_CONFIGURATION_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcIngressConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcIngressConnectionArn;
    private final String vpcIngressConnectionName;
    private final String serviceArn;
    private final String status;
    private final String accountId;
    private final String domainName;
    private final IngressVpcConfiguration ingressVpcConfiguration;
    private final Instant createdAt;
    private final Instant deletedAt;

    private VpcIngressConnection(BuilderImpl builder) {
        this.vpcIngressConnectionArn = builder.vpcIngressConnectionArn;
        this.vpcIngressConnectionName = builder.vpcIngressConnectionName;
        this.serviceArn = builder.serviceArn;
        this.status = builder.status;
        this.accountId = builder.accountId;
        this.domainName = builder.domainName;
        this.ingressVpcConfiguration = builder.ingressVpcConfiguration;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
    }

    public final String vpcIngressConnectionArn() {
        return this.vpcIngressConnectionArn;
    }

    public final String vpcIngressConnectionName() {
        return this.vpcIngressConnectionName;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final VpcIngressConnectionStatus status() {
        return VpcIngressConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final IngressVpcConfiguration ingressVpcConfiguration() {
        return this.ingressVpcConfiguration;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIngressConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIngressConnectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressVpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcIngressConnection)) {
            return false;
        }
        VpcIngressConnection other = (VpcIngressConnection)obj;
        return Objects.equals(this.vpcIngressConnectionArn(), other.vpcIngressConnectionArn()) && Objects.equals(this.vpcIngressConnectionName(), other.vpcIngressConnectionName()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.ingressVpcConfiguration(), other.ingressVpcConfiguration()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deletedAt(), other.deletedAt());
    }

    public final String toString() {
        return ToString.builder((String)"VpcIngressConnection").add("VpcIngressConnectionArn", (Object)this.vpcIngressConnectionArn()).add("VpcIngressConnectionName", (Object)this.vpcIngressConnectionName()).add("ServiceArn", (Object)this.serviceArn()).add("Status", (Object)this.statusAsString()).add("AccountId", (Object)this.accountId()).add("DomainName", (Object)this.domainName()).add("IngressVpcConfiguration", (Object)this.ingressVpcConfiguration()).add("CreatedAt", (Object)this.createdAt()).add("DeletedAt", (Object)this.deletedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcIngressConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcIngressConnectionArn()));
            }
            case "VpcIngressConnectionName": {
                return Optional.ofNullable(clazz.cast(this.vpcIngressConnectionName()));
            }
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "IngressVpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ingressVpcConfiguration()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DeletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcIngressConnectionArn", VPC_INGRESS_CONNECTION_ARN_FIELD);
        map.put("VpcIngressConnectionName", VPC_INGRESS_CONNECTION_NAME_FIELD);
        map.put("ServiceArn", SERVICE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("IngressVpcConfiguration", INGRESS_VPC_CONFIGURATION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("DeletedAt", DELETED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcIngressConnection, T> g) {
        return obj -> g.apply((VpcIngressConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcIngressConnectionArn;
        private String vpcIngressConnectionName;
        private String serviceArn;
        private String status;
        private String accountId;
        private String domainName;
        private IngressVpcConfiguration ingressVpcConfiguration;
        private Instant createdAt;
        private Instant deletedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcIngressConnection model) {
            this.vpcIngressConnectionArn(model.vpcIngressConnectionArn);
            this.vpcIngressConnectionName(model.vpcIngressConnectionName);
            this.serviceArn(model.serviceArn);
            this.status(model.status);
            this.accountId(model.accountId);
            this.domainName(model.domainName);
            this.ingressVpcConfiguration(model.ingressVpcConfiguration);
            this.createdAt(model.createdAt);
            this.deletedAt(model.deletedAt);
        }

        public final String getVpcIngressConnectionArn() {
            return this.vpcIngressConnectionArn;
        }

        public final void setVpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
        }

        @Override
        public final Builder vpcIngressConnectionArn(String vpcIngressConnectionArn) {
            this.vpcIngressConnectionArn = vpcIngressConnectionArn;
            return this;
        }

        public final String getVpcIngressConnectionName() {
            return this.vpcIngressConnectionName;
        }

        public final void setVpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
        }

        @Override
        public final Builder vpcIngressConnectionName(String vpcIngressConnectionName) {
            this.vpcIngressConnectionName = vpcIngressConnectionName;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VpcIngressConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final IngressVpcConfiguration.Builder getIngressVpcConfiguration() {
            return this.ingressVpcConfiguration != null ? this.ingressVpcConfiguration.toBuilder() : null;
        }

        public final void setIngressVpcConfiguration(IngressVpcConfiguration.BuilderImpl ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration != null ? ingressVpcConfiguration.build() : null;
        }

        @Override
        public final Builder ingressVpcConfiguration(IngressVpcConfiguration ingressVpcConfiguration) {
            this.ingressVpcConfiguration = ingressVpcConfiguration;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public VpcIngressConnection build() {
            return new VpcIngressConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcIngressConnection> {
        public Builder vpcIngressConnectionArn(String var1);

        public Builder vpcIngressConnectionName(String var1);

        public Builder serviceArn(String var1);

        public Builder status(String var1);

        public Builder status(VpcIngressConnectionStatus var1);

        public Builder accountId(String var1);

        public Builder domainName(String var1);

        public Builder ingressVpcConfiguration(IngressVpcConfiguration var1);

        default public Builder ingressVpcConfiguration(Consumer<IngressVpcConfiguration.Builder> ingressVpcConfiguration) {
            return this.ingressVpcConfiguration((IngressVpcConfiguration)((IngressVpcConfiguration.Builder)IngressVpcConfiguration.builder().applyMutation(ingressVpcConfiguration)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder deletedAt(Instant var1);
    }
}

