/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.ServiceArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesForAutoScalingConfigurationResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListServicesForAutoScalingConfigurationResponse> {
    private static final SdkField<List<String>> SERVICE_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceArnList").getter(ListServicesForAutoScalingConfigurationResponse.getter(ListServicesForAutoScalingConfigurationResponse::serviceArnList)).setter(ListServicesForAutoScalingConfigurationResponse.setter(Builder::serviceArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServicesForAutoScalingConfigurationResponse.getter(ListServicesForAutoScalingConfigurationResponse::nextToken)).setter(ListServicesForAutoScalingConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceArnList", SERVICE_ARN_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> serviceArnList;
    private final String nextToken;

    private ListServicesForAutoScalingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.serviceArnList = builder.serviceArnList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceArnList() {
        return this.serviceArnList != null && !(this.serviceArnList instanceof SdkAutoConstructList);
    }

    public final List<String> serviceArnList() {
        return this.serviceArnList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceArnList() ? this.serviceArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesForAutoScalingConfigurationResponse)) {
            return false;
        }
        ListServicesForAutoScalingConfigurationResponse other = (ListServicesForAutoScalingConfigurationResponse)((Object)obj);
        return this.hasServiceArnList() == other.hasServiceArnList() && Objects.equals(this.serviceArnList(), other.serviceArnList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicesForAutoScalingConfigurationResponse").add("ServiceArnList", this.hasServiceArnList() ? this.serviceArnList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceArnList": {
                return Optional.ofNullable(clazz.cast(this.serviceArnList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesForAutoScalingConfigurationResponse, T> g) {
        return obj -> g.apply((ListServicesForAutoScalingConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<String> serviceArnList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesForAutoScalingConfigurationResponse model) {
            super(model);
            this.serviceArnList(model.serviceArnList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getServiceArnList() {
            if (this.serviceArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceArnList;
        }

        public final void setServiceArnList(Collection<String> serviceArnList) {
            this.serviceArnList = ServiceArnListCopier.copy(serviceArnList);
        }

        @Override
        public final Builder serviceArnList(Collection<String> serviceArnList) {
            this.serviceArnList = ServiceArnListCopier.copy(serviceArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArnList(String ... serviceArnList) {
            this.serviceArnList(Arrays.asList(serviceArnList));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServicesForAutoScalingConfigurationResponse build() {
            return new ListServicesForAutoScalingConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesForAutoScalingConfigurationResponse> {
        public Builder serviceArnList(Collection<String> var1);

        public Builder serviceArnList(String ... var1);

        public Builder nextToken(String var1);
    }
}

