/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.ImageConfiguration;
import software.amazon.awssdk.services.apprunner.model.ImageRepositoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageRepository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageRepository> {
    private static final SdkField<String> IMAGE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageIdentifier").getter(ImageRepository.getter(ImageRepository::imageIdentifier)).setter(ImageRepository.setter(Builder::imageIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageIdentifier").build()}).build();
    private static final SdkField<ImageConfiguration> IMAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfiguration").getter(ImageRepository.getter(ImageRepository::imageConfiguration)).setter(ImageRepository.setter(Builder::imageConfiguration)).constructor(ImageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfiguration").build()}).build();
    private static final SdkField<String> IMAGE_REPOSITORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageRepositoryType").getter(ImageRepository.getter(ImageRepository::imageRepositoryTypeAsString)).setter(ImageRepository.setter(Builder::imageRepositoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageRepositoryType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_IDENTIFIER_FIELD, IMAGE_CONFIGURATION_FIELD, IMAGE_REPOSITORY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImageIdentifier", IMAGE_IDENTIFIER_FIELD);
            this.put("ImageConfiguration", IMAGE_CONFIGURATION_FIELD);
            this.put("ImageRepositoryType", IMAGE_REPOSITORY_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String imageIdentifier;
    private final ImageConfiguration imageConfiguration;
    private final String imageRepositoryType;

    private ImageRepository(BuilderImpl builder) {
        this.imageIdentifier = builder.imageIdentifier;
        this.imageConfiguration = builder.imageConfiguration;
        this.imageRepositoryType = builder.imageRepositoryType;
    }

    public final String imageIdentifier() {
        return this.imageIdentifier;
    }

    public final ImageConfiguration imageConfiguration() {
        return this.imageConfiguration;
    }

    public final ImageRepositoryType imageRepositoryType() {
        return ImageRepositoryType.fromValue(this.imageRepositoryType);
    }

    public final String imageRepositoryTypeAsString() {
        return this.imageRepositoryType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRepositoryTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageRepository)) {
            return false;
        }
        ImageRepository other = (ImageRepository)obj;
        return Objects.equals(this.imageIdentifier(), other.imageIdentifier()) && Objects.equals(this.imageConfiguration(), other.imageConfiguration()) && Objects.equals(this.imageRepositoryTypeAsString(), other.imageRepositoryTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageRepository").add("ImageIdentifier", (Object)this.imageIdentifier()).add("ImageConfiguration", (Object)this.imageConfiguration()).add("ImageRepositoryType", (Object)this.imageRepositoryTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageIdentifier": {
                return Optional.ofNullable(clazz.cast(this.imageIdentifier()));
            }
            case "ImageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageConfiguration()));
            }
            case "ImageRepositoryType": {
                return Optional.ofNullable(clazz.cast(this.imageRepositoryTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImageRepository, T> g) {
        return obj -> g.apply((ImageRepository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageIdentifier;
        private ImageConfiguration imageConfiguration;
        private String imageRepositoryType;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageRepository model) {
            this.imageIdentifier(model.imageIdentifier);
            this.imageConfiguration(model.imageConfiguration);
            this.imageRepositoryType(model.imageRepositoryType);
        }

        public final String getImageIdentifier() {
            return this.imageIdentifier;
        }

        public final void setImageIdentifier(String imageIdentifier) {
            this.imageIdentifier = imageIdentifier;
        }

        @Override
        public final Builder imageIdentifier(String imageIdentifier) {
            this.imageIdentifier = imageIdentifier;
            return this;
        }

        public final ImageConfiguration.Builder getImageConfiguration() {
            return this.imageConfiguration != null ? this.imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(ImageConfiguration.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(ImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public final String getImageRepositoryType() {
            return this.imageRepositoryType;
        }

        public final void setImageRepositoryType(String imageRepositoryType) {
            this.imageRepositoryType = imageRepositoryType;
        }

        @Override
        public final Builder imageRepositoryType(String imageRepositoryType) {
            this.imageRepositoryType = imageRepositoryType;
            return this;
        }

        @Override
        public final Builder imageRepositoryType(ImageRepositoryType imageRepositoryType) {
            this.imageRepositoryType(imageRepositoryType == null ? null : imageRepositoryType.toString());
            return this;
        }

        public ImageRepository build() {
            return new ImageRepository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageRepository> {
        public Builder imageIdentifier(String var1);

        public Builder imageConfiguration(ImageConfiguration var1);

        default public Builder imageConfiguration(Consumer<ImageConfiguration.Builder> imageConfiguration) {
            return this.imageConfiguration((ImageConfiguration)((ImageConfiguration.Builder)ImageConfiguration.builder().applyMutation(imageConfiguration)).build());
        }

        public Builder imageRepositoryType(String var1);

        public Builder imageRepositoryType(ImageRepositoryType var1);
    }
}

