/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.CustomDomain;
import software.amazon.awssdk.services.apprunner.model.CustomDomainListCopier;
import software.amazon.awssdk.services.apprunner.model.VpcDNSTarget;
import software.amazon.awssdk.services.apprunner.model.VpcDNSTargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomDomainsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, DescribeCustomDomainsResponse> {
    private static final SdkField<String> DNS_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSTarget").getter(DescribeCustomDomainsResponse.getter(DescribeCustomDomainsResponse::dnsTarget)).setter(DescribeCustomDomainsResponse.setter(Builder::dnsTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSTarget").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(DescribeCustomDomainsResponse.getter(DescribeCustomDomainsResponse::serviceArn)).setter(DescribeCustomDomainsResponse.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<List<CustomDomain>> CUSTOM_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomDomains").getter(DescribeCustomDomainsResponse.getter(DescribeCustomDomainsResponse::customDomains)).setter(DescribeCustomDomainsResponse.setter(Builder::customDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VpcDNSTarget>> VPC_DNS_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcDNSTargets").getter(DescribeCustomDomainsResponse.getter(DescribeCustomDomainsResponse::vpcDNSTargets)).setter(DescribeCustomDomainsResponse.setter(Builder::vpcDNSTargets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcDNSTargets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcDNSTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCustomDomainsResponse.getter(DescribeCustomDomainsResponse::nextToken)).setter(DescribeCustomDomainsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_TARGET_FIELD, SERVICE_ARN_FIELD, CUSTOM_DOMAINS_FIELD, VPC_DNS_TARGETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DNSTarget", DNS_TARGET_FIELD);
            this.put("ServiceArn", SERVICE_ARN_FIELD);
            this.put("CustomDomains", CUSTOM_DOMAINS_FIELD);
            this.put("VpcDNSTargets", VPC_DNS_TARGETS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String dnsTarget;
    private final String serviceArn;
    private final List<CustomDomain> customDomains;
    private final List<VpcDNSTarget> vpcDNSTargets;
    private final String nextToken;

    private DescribeCustomDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.dnsTarget = builder.dnsTarget;
        this.serviceArn = builder.serviceArn;
        this.customDomains = builder.customDomains;
        this.vpcDNSTargets = builder.vpcDNSTargets;
        this.nextToken = builder.nextToken;
    }

    public final String dnsTarget() {
        return this.dnsTarget;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final boolean hasCustomDomains() {
        return this.customDomains != null && !(this.customDomains instanceof SdkAutoConstructList);
    }

    public final List<CustomDomain> customDomains() {
        return this.customDomains;
    }

    public final boolean hasVpcDNSTargets() {
        return this.vpcDNSTargets != null && !(this.vpcDNSTargets instanceof SdkAutoConstructList);
    }

    public final List<VpcDNSTarget> vpcDNSTargets() {
        return this.vpcDNSTargets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomDomains() ? this.customDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcDNSTargets() ? this.vpcDNSTargets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomDomainsResponse)) {
            return false;
        }
        DescribeCustomDomainsResponse other = (DescribeCustomDomainsResponse)((Object)obj);
        return Objects.equals(this.dnsTarget(), other.dnsTarget()) && Objects.equals(this.serviceArn(), other.serviceArn()) && this.hasCustomDomains() == other.hasCustomDomains() && Objects.equals(this.customDomains(), other.customDomains()) && this.hasVpcDNSTargets() == other.hasVpcDNSTargets() && Objects.equals(this.vpcDNSTargets(), other.vpcDNSTargets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomDomainsResponse").add("DNSTarget", (Object)this.dnsTarget()).add("ServiceArn", (Object)this.serviceArn()).add("CustomDomains", this.hasCustomDomains() ? this.customDomains() : null).add("VpcDNSTargets", this.hasVpcDNSTargets() ? this.vpcDNSTargets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DNSTarget": {
                return Optional.ofNullable(clazz.cast(this.dnsTarget()));
            }
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "CustomDomains": {
                return Optional.ofNullable(clazz.cast(this.customDomains()));
            }
            case "VpcDNSTargets": {
                return Optional.ofNullable(clazz.cast(this.vpcDNSTargets()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomDomainsResponse, T> g) {
        return obj -> g.apply((DescribeCustomDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private String dnsTarget;
        private String serviceArn;
        private List<CustomDomain> customDomains = DefaultSdkAutoConstructList.getInstance();
        private List<VpcDNSTarget> vpcDNSTargets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomDomainsResponse model) {
            super(model);
            this.dnsTarget(model.dnsTarget);
            this.serviceArn(model.serviceArn);
            this.customDomains(model.customDomains);
            this.vpcDNSTargets(model.vpcDNSTargets);
            this.nextToken(model.nextToken);
        }

        public final String getDnsTarget() {
            return this.dnsTarget;
        }

        public final void setDnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
        }

        @Override
        public final Builder dnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final List<CustomDomain.Builder> getCustomDomains() {
            List<CustomDomain.Builder> result = CustomDomainListCopier.copyToBuilder(this.customDomains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomDomains(Collection<CustomDomain.BuilderImpl> customDomains) {
            this.customDomains = CustomDomainListCopier.copyFromBuilder(customDomains);
        }

        @Override
        public final Builder customDomains(Collection<CustomDomain> customDomains) {
            this.customDomains = CustomDomainListCopier.copy(customDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDomains(CustomDomain ... customDomains) {
            this.customDomains(Arrays.asList(customDomains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customDomains(Consumer<CustomDomain.Builder> ... customDomains) {
            this.customDomains(Stream.of(customDomains).map(c -> (CustomDomain)((CustomDomain.Builder)CustomDomain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcDNSTarget.Builder> getVpcDNSTargets() {
            List<VpcDNSTarget.Builder> result = VpcDNSTargetListCopier.copyToBuilder(this.vpcDNSTargets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcDNSTargets(Collection<VpcDNSTarget.BuilderImpl> vpcDNSTargets) {
            this.vpcDNSTargets = VpcDNSTargetListCopier.copyFromBuilder(vpcDNSTargets);
        }

        @Override
        public final Builder vpcDNSTargets(Collection<VpcDNSTarget> vpcDNSTargets) {
            this.vpcDNSTargets = VpcDNSTargetListCopier.copy(vpcDNSTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcDNSTargets(VpcDNSTarget ... vpcDNSTargets) {
            this.vpcDNSTargets(Arrays.asList(vpcDNSTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcDNSTargets(Consumer<VpcDNSTarget.Builder> ... vpcDNSTargets) {
            this.vpcDNSTargets(Stream.of(vpcDNSTargets).map(c -> (VpcDNSTarget)((VpcDNSTarget.Builder)VpcDNSTarget.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCustomDomainsResponse build() {
            return new DescribeCustomDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomDomainsResponse> {
        public Builder dnsTarget(String var1);

        public Builder serviceArn(String var1);

        public Builder customDomains(Collection<CustomDomain> var1);

        public Builder customDomains(CustomDomain ... var1);

        public Builder customDomains(Consumer<CustomDomain.Builder> ... var1);

        public Builder vpcDNSTargets(Collection<VpcDNSTarget> var1);

        public Builder vpcDNSTargets(VpcDNSTarget ... var1);

        public Builder vpcDNSTargets(Consumer<VpcDNSTarget.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

