/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingConfigurationSummary> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationArn").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::autoScalingConfigurationArn)).setter(AutoScalingConfigurationSummary.setter(Builder::autoScalingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn").build()}).build();
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationName").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::autoScalingConfigurationName)).setter(AutoScalingConfigurationSummary.setter(Builder::autoScalingConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationName").build()}).build();
    private static final SdkField<Integer> AUTO_SCALING_CONFIGURATION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutoScalingConfigurationRevision").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::autoScalingConfigurationRevision)).setter(AutoScalingConfigurationSummary.setter(Builder::autoScalingConfigurationRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationRevision").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::statusAsString)).setter(AutoScalingConfigurationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::createdAt)).setter(AutoScalingConfigurationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Boolean> HAS_ASSOCIATED_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasAssociatedService").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::hasAssociatedService)).setter(AutoScalingConfigurationSummary.setter(Builder::hasAssociatedService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAssociatedService").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(AutoScalingConfigurationSummary.getter(AutoScalingConfigurationSummary::isDefault)).setter(AutoScalingConfigurationSummary.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_CONFIGURATION_ARN_FIELD, AUTO_SCALING_CONFIGURATION_NAME_FIELD, AUTO_SCALING_CONFIGURATION_REVISION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, HAS_ASSOCIATED_SERVICE_FIELD, IS_DEFAULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingConfigurationArn;
    private final String autoScalingConfigurationName;
    private final Integer autoScalingConfigurationRevision;
    private final String status;
    private final Instant createdAt;
    private final Boolean hasAssociatedService;
    private final Boolean isDefault;

    private AutoScalingConfigurationSummary(BuilderImpl builder) {
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.autoScalingConfigurationName = builder.autoScalingConfigurationName;
        this.autoScalingConfigurationRevision = builder.autoScalingConfigurationRevision;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.hasAssociatedService = builder.hasAssociatedService;
        this.isDefault = builder.isDefault;
    }

    public final String autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }

    public final String autoScalingConfigurationName() {
        return this.autoScalingConfigurationName;
    }

    public final Integer autoScalingConfigurationRevision() {
        return this.autoScalingConfigurationRevision;
    }

    public final AutoScalingConfigurationStatus status() {
        return AutoScalingConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Boolean hasAssociatedService() {
        return this.hasAssociatedService;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedService());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfigurationSummary)) {
            return false;
        }
        AutoScalingConfigurationSummary other = (AutoScalingConfigurationSummary)obj;
        return Objects.equals(this.autoScalingConfigurationArn(), other.autoScalingConfigurationArn()) && Objects.equals(this.autoScalingConfigurationName(), other.autoScalingConfigurationName()) && Objects.equals(this.autoScalingConfigurationRevision(), other.autoScalingConfigurationRevision()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.hasAssociatedService(), other.hasAssociatedService()) && Objects.equals(this.isDefault(), other.isDefault());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingConfigurationSummary").add("AutoScalingConfigurationArn", (Object)this.autoScalingConfigurationArn()).add("AutoScalingConfigurationName", (Object)this.autoScalingConfigurationName()).add("AutoScalingConfigurationRevision", (Object)this.autoScalingConfigurationRevision()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("HasAssociatedService", (Object)this.hasAssociatedService()).add("IsDefault", (Object)this.isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationArn()));
            }
            case "AutoScalingConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationName()));
            }
            case "AutoScalingConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationRevision()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "HasAssociatedService": {
                return Optional.ofNullable(clazz.cast(this.hasAssociatedService()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfigurationSummary, T> g) {
        return obj -> g.apply((AutoScalingConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingConfigurationArn;
        private String autoScalingConfigurationName;
        private Integer autoScalingConfigurationRevision;
        private String status;
        private Instant createdAt;
        private Boolean hasAssociatedService;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfigurationSummary model) {
            this.autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            this.autoScalingConfigurationName(model.autoScalingConfigurationName);
            this.autoScalingConfigurationRevision(model.autoScalingConfigurationRevision);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.hasAssociatedService(model.hasAssociatedService);
            this.isDefault(model.isDefault);
        }

        public final String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final String getAutoScalingConfigurationName() {
            return this.autoScalingConfigurationName;
        }

        public final void setAutoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
        }

        @Override
        public final Builder autoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
            return this;
        }

        public final Integer getAutoScalingConfigurationRevision() {
            return this.autoScalingConfigurationRevision;
        }

        public final void setAutoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
        }

        @Override
        public final Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoScalingConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getHasAssociatedService() {
            return this.hasAssociatedService;
        }

        public final void setHasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
        }

        @Override
        public final Builder hasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public AutoScalingConfigurationSummary build() {
            return new AutoScalingConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingConfigurationSummary> {
        public Builder autoScalingConfigurationArn(String var1);

        public Builder autoScalingConfigurationName(String var1);

        public Builder autoScalingConfigurationRevision(Integer var1);

        public Builder status(String var1);

        public Builder status(AutoScalingConfigurationStatus var1);

        public Builder createdAt(Instant var1);

        public Builder hasAssociatedService(Boolean var1);

        public Builder isDefault(Boolean var1);
    }
}

