/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AutoScalingConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingConfiguration> {
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationArn").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::autoScalingConfigurationArn)).setter(AutoScalingConfiguration.setter(Builder::autoScalingConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationArn").build()}).build();
    private static final SdkField<String> AUTO_SCALING_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingConfigurationName").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::autoScalingConfigurationName)).setter(AutoScalingConfiguration.setter(Builder::autoScalingConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationName").build()}).build();
    private static final SdkField<Integer> AUTO_SCALING_CONFIGURATION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutoScalingConfigurationRevision").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::autoScalingConfigurationRevision)).setter(AutoScalingConfiguration.setter(Builder::autoScalingConfigurationRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingConfigurationRevision").build()}).build();
    private static final SdkField<Boolean> LATEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Latest").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::latest)).setter(AutoScalingConfiguration.setter(Builder::latest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Latest").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::statusAsString)).setter(AutoScalingConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrency").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::maxConcurrency)).setter(AutoScalingConfiguration.setter(Builder::maxConcurrency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinSize").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::minSize)).setter(AutoScalingConfiguration.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxSize").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::maxSize)).setter(AutoScalingConfiguration.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::createdAt)).setter(AutoScalingConfiguration.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> DELETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletedAt").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::deletedAt)).setter(AutoScalingConfiguration.setter(Builder::deletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletedAt").build()}).build();
    private static final SdkField<Boolean> HAS_ASSOCIATED_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HasAssociatedService").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::hasAssociatedService)).setter(AutoScalingConfiguration.setter(Builder::hasAssociatedService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasAssociatedService").build()}).build();
    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDefault").getter(AutoScalingConfiguration.getter(AutoScalingConfiguration::isDefault)).setter(AutoScalingConfiguration.setter(Builder::isDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_CONFIGURATION_ARN_FIELD, AUTO_SCALING_CONFIGURATION_NAME_FIELD, AUTO_SCALING_CONFIGURATION_REVISION_FIELD, LATEST_FIELD, STATUS_FIELD, MAX_CONCURRENCY_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, CREATED_AT_FIELD, DELETED_AT_FIELD, HAS_ASSOCIATED_SERVICE_FIELD, IS_DEFAULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String autoScalingConfigurationArn;
    private final String autoScalingConfigurationName;
    private final Integer autoScalingConfigurationRevision;
    private final Boolean latest;
    private final String status;
    private final Integer maxConcurrency;
    private final Integer minSize;
    private final Integer maxSize;
    private final Instant createdAt;
    private final Instant deletedAt;
    private final Boolean hasAssociatedService;
    private final Boolean isDefault;

    private AutoScalingConfiguration(BuilderImpl builder) {
        this.autoScalingConfigurationArn = builder.autoScalingConfigurationArn;
        this.autoScalingConfigurationName = builder.autoScalingConfigurationName;
        this.autoScalingConfigurationRevision = builder.autoScalingConfigurationRevision;
        this.latest = builder.latest;
        this.status = builder.status;
        this.maxConcurrency = builder.maxConcurrency;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.createdAt = builder.createdAt;
        this.deletedAt = builder.deletedAt;
        this.hasAssociatedService = builder.hasAssociatedService;
        this.isDefault = builder.isDefault;
    }

    public final String autoScalingConfigurationArn() {
        return this.autoScalingConfigurationArn;
    }

    public final String autoScalingConfigurationName() {
        return this.autoScalingConfigurationName;
    }

    public final Integer autoScalingConfigurationRevision() {
        return this.autoScalingConfigurationRevision;
    }

    public final Boolean latest() {
        return this.latest;
    }

    public final AutoScalingConfigurationStatus status() {
        return AutoScalingConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer maxConcurrency() {
        return this.maxConcurrency;
    }

    public final Integer minSize() {
        return this.minSize;
    }

    public final Integer maxSize() {
        return this.maxSize;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant deletedAt() {
        return this.deletedAt;
    }

    public final Boolean hasAssociatedService() {
        return this.hasAssociatedService;
    }

    public final Boolean isDefault() {
        return this.isDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingConfigurationRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.latest());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedService());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDefault());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingConfiguration)) {
            return false;
        }
        AutoScalingConfiguration other = (AutoScalingConfiguration)obj;
        return Objects.equals(this.autoScalingConfigurationArn(), other.autoScalingConfigurationArn()) && Objects.equals(this.autoScalingConfigurationName(), other.autoScalingConfigurationName()) && Objects.equals(this.autoScalingConfigurationRevision(), other.autoScalingConfigurationRevision()) && Objects.equals(this.latest(), other.latest()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.maxConcurrency(), other.maxConcurrency()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deletedAt(), other.deletedAt()) && Objects.equals(this.hasAssociatedService(), other.hasAssociatedService()) && Objects.equals(this.isDefault(), other.isDefault());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingConfiguration").add("AutoScalingConfigurationArn", (Object)this.autoScalingConfigurationArn()).add("AutoScalingConfigurationName", (Object)this.autoScalingConfigurationName()).add("AutoScalingConfigurationRevision", (Object)this.autoScalingConfigurationRevision()).add("Latest", (Object)this.latest()).add("Status", (Object)this.statusAsString()).add("MaxConcurrency", (Object)this.maxConcurrency()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("CreatedAt", (Object)this.createdAt()).add("DeletedAt", (Object)this.deletedAt()).add("HasAssociatedService", (Object)this.hasAssociatedService()).add("IsDefault", (Object)this.isDefault()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationArn()));
            }
            case "AutoScalingConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationName()));
            }
            case "AutoScalingConfigurationRevision": {
                return Optional.ofNullable(clazz.cast(this.autoScalingConfigurationRevision()));
            }
            case "Latest": {
                return Optional.ofNullable(clazz.cast(this.latest()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "MaxConcurrency": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrency()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "DeletedAt": {
                return Optional.ofNullable(clazz.cast(this.deletedAt()));
            }
            case "HasAssociatedService": {
                return Optional.ofNullable(clazz.cast(this.hasAssociatedService()));
            }
            case "IsDefault": {
                return Optional.ofNullable(clazz.cast(this.isDefault()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingConfiguration, T> g) {
        return obj -> g.apply((AutoScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingConfigurationArn;
        private String autoScalingConfigurationName;
        private Integer autoScalingConfigurationRevision;
        private Boolean latest;
        private String status;
        private Integer maxConcurrency;
        private Integer minSize;
        private Integer maxSize;
        private Instant createdAt;
        private Instant deletedAt;
        private Boolean hasAssociatedService;
        private Boolean isDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingConfiguration model) {
            this.autoScalingConfigurationArn(model.autoScalingConfigurationArn);
            this.autoScalingConfigurationName(model.autoScalingConfigurationName);
            this.autoScalingConfigurationRevision(model.autoScalingConfigurationRevision);
            this.latest(model.latest);
            this.status(model.status);
            this.maxConcurrency(model.maxConcurrency);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.createdAt(model.createdAt);
            this.deletedAt(model.deletedAt);
            this.hasAssociatedService(model.hasAssociatedService);
            this.isDefault(model.isDefault);
        }

        public final String getAutoScalingConfigurationArn() {
            return this.autoScalingConfigurationArn;
        }

        public final void setAutoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
        }

        @Override
        public final Builder autoScalingConfigurationArn(String autoScalingConfigurationArn) {
            this.autoScalingConfigurationArn = autoScalingConfigurationArn;
            return this;
        }

        public final String getAutoScalingConfigurationName() {
            return this.autoScalingConfigurationName;
        }

        public final void setAutoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
        }

        @Override
        public final Builder autoScalingConfigurationName(String autoScalingConfigurationName) {
            this.autoScalingConfigurationName = autoScalingConfigurationName;
            return this;
        }

        public final Integer getAutoScalingConfigurationRevision() {
            return this.autoScalingConfigurationRevision;
        }

        public final void setAutoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
        }

        @Override
        public final Builder autoScalingConfigurationRevision(Integer autoScalingConfigurationRevision) {
            this.autoScalingConfigurationRevision = autoScalingConfigurationRevision;
            return this;
        }

        public final Boolean getLatest() {
            return this.latest;
        }

        public final void setLatest(Boolean latest) {
            this.latest = latest;
        }

        @Override
        public final Builder latest(Boolean latest) {
            this.latest = latest;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutoScalingConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getDeletedAt() {
            return this.deletedAt;
        }

        public final void setDeletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
        }

        @Override
        public final Builder deletedAt(Instant deletedAt) {
            this.deletedAt = deletedAt;
            return this;
        }

        public final Boolean getHasAssociatedService() {
            return this.hasAssociatedService;
        }

        public final void setHasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
        }

        @Override
        public final Builder hasAssociatedService(Boolean hasAssociatedService) {
            this.hasAssociatedService = hasAssociatedService;
            return this;
        }

        public final Boolean getIsDefault() {
            return this.isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public AutoScalingConfiguration build() {
            return new AutoScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingConfiguration> {
        public Builder autoScalingConfigurationArn(String var1);

        public Builder autoScalingConfigurationName(String var1);

        public Builder autoScalingConfigurationRevision(Integer var1);

        public Builder latest(Boolean var1);

        public Builder status(String var1);

        public Builder status(AutoScalingConfigurationStatus var1);

        public Builder maxConcurrency(Integer var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder deletedAt(Instant var1);

        public Builder hasAssociatedService(Boolean var1);

        public Builder isDefault(Boolean var1);
    }
}

