/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration of the tracing feature within an App Runner observability configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TraceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TraceConfiguration.Builder, TraceConfiguration> {
    private static final SdkField<String> VENDOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Vendor")
            .getter(getter(TraceConfiguration::vendorAsString)).setter(setter(Builder::vendor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vendor;

    private TraceConfiguration(BuilderImpl builder) {
        this.vendor = builder.vendor;
    }

    /**
     * <p>
     * The implementation provider chosen for tracing App Runner services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendor} will
     * return {@link TracingVendor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vendorAsString}.
     * </p>
     * 
     * @return The implementation provider chosen for tracing App Runner services.
     * @see TracingVendor
     */
    public final TracingVendor vendor() {
        return TracingVendor.fromValue(vendor);
    }

    /**
     * <p>
     * The implementation provider chosen for tracing App Runner services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vendor} will
     * return {@link TracingVendor#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vendorAsString}.
     * </p>
     * 
     * @return The implementation provider chosen for tracing App Runner services.
     * @see TracingVendor
     */
    public final String vendorAsString() {
        return vendor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TraceConfiguration)) {
            return false;
        }
        TraceConfiguration other = (TraceConfiguration) obj;
        return Objects.equals(vendorAsString(), other.vendorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TraceConfiguration").add("Vendor", vendorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TraceConfiguration, T> g) {
        return obj -> g.apply((TraceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TraceConfiguration> {
        /**
         * <p>
         * The implementation provider chosen for tracing App Runner services.
         * </p>
         * 
         * @param vendor
         *        The implementation provider chosen for tracing App Runner services.
         * @see TracingVendor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingVendor
         */
        Builder vendor(String vendor);

        /**
         * <p>
         * The implementation provider chosen for tracing App Runner services.
         * </p>
         * 
         * @param vendor
         *        The implementation provider chosen for tracing App Runner services.
         * @see TracingVendor
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingVendor
         */
        Builder vendor(TracingVendor vendor);
    }

    static final class BuilderImpl implements Builder {
        private String vendor;

        private BuilderImpl() {
        }

        private BuilderImpl(TraceConfiguration model) {
            vendor(model.vendor);
        }

        public final String getVendor() {
            return vendor;
        }

        public final void setVendor(String vendor) {
            this.vendor = vendor;
        }

        @Override
        public final Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        @Override
        public final Builder vendor(TracingVendor vendor) {
            this.vendor(vendor == null ? null : vendor.toString());
            return this;
        }

        @Override
        public TraceConfiguration build() {
            return new TraceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
