/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListObservabilityConfigurationsRequest extends AppRunnerRequest implements
        ToCopyableBuilder<ListObservabilityConfigurationsRequest.Builder, ListObservabilityConfigurationsRequest> {
    private static final SdkField<String> OBSERVABILITY_CONFIGURATION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObservabilityConfigurationName")
            .getter(getter(ListObservabilityConfigurationsRequest::observabilityConfigurationName))
            .setter(setter(Builder::observabilityConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObservabilityConfigurationName")
                    .build()).build();

    private static final SdkField<Boolean> LATEST_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("LatestOnly").getter(getter(ListObservabilityConfigurationsRequest::latestOnly))
            .setter(setter(Builder::latestOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestOnly").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListObservabilityConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListObservabilityConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBSERVABILITY_CONFIGURATION_NAME_FIELD, LATEST_ONLY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String observabilityConfigurationName;

    private final Boolean latestOnly;

    private final Integer maxResults;

    private final String nextToken;

    private ListObservabilityConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.observabilityConfigurationName = builder.observabilityConfigurationName;
        this.latestOnly = builder.latestOnly;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the App Runner observability configuration that you want to list. If specified, App Runner lists
     * revisions that share this name. If not specified, App Runner returns revisions of all active configurations.
     * </p>
     * 
     * @return The name of the App Runner observability configuration that you want to list. If specified, App Runner
     *         lists revisions that share this name. If not specified, App Runner returns revisions of all active
     *         configurations.
     */
    public final String observabilityConfigurationName() {
        return observabilityConfigurationName;
    }

    /**
     * <p>
     * Set to <code>true</code> to list only the latest revision for each requested configuration name.
     * </p>
     * <p>
     * Set to <code>false</code> to list all revisions for each requested configuration name.
     * </p>
     * <p>
     * Default: <code>true</code>
     * </p>
     * 
     * @return Set to <code>true</code> to list only the latest revision for each requested configuration name.</p>
     *         <p>
     *         Set to <code>false</code> to list all revisions for each requested configuration name.
     *         </p>
     *         <p>
     *         Default: <code>true</code>
     */
    public final Boolean latestOnly() {
        return latestOnly;
    }

    /**
     * <p>
     * The maximum number of results to include in each response (result page). It's used for a paginated request.
     * </p>
     * <p>
     * If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single response.
     * </p>
     * 
     * @return The maximum number of results to include in each response (result page). It's used for a paginated
     *         request.</p>
     *         <p>
     *         If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single
     *         response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token from a previous result page. It's used for a paginated request. The request retrieves the next result
     * page. All other parameter values must be identical to the ones that are specified in the initial request.
     * </p>
     * <p>
     * If you don't specify <code>NextToken</code>, the request retrieves the first result page.
     * </p>
     * 
     * @return A token from a previous result page. It's used for a paginated request. The request retrieves the next
     *         result page. All other parameter values must be identical to the ones that are specified in the initial
     *         request.</p>
     *         <p>
     *         If you don't specify <code>NextToken</code>, the request retrieves the first result page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(observabilityConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(latestOnly());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObservabilityConfigurationsRequest)) {
            return false;
        }
        ListObservabilityConfigurationsRequest other = (ListObservabilityConfigurationsRequest) obj;
        return Objects.equals(observabilityConfigurationName(), other.observabilityConfigurationName())
                && Objects.equals(latestOnly(), other.latestOnly()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListObservabilityConfigurationsRequest")
                .add("ObservabilityConfigurationName", observabilityConfigurationName()).add("LatestOnly", latestOnly())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObservabilityConfigurationName":
            return Optional.ofNullable(clazz.cast(observabilityConfigurationName()));
        case "LatestOnly":
            return Optional.ofNullable(clazz.cast(latestOnly()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListObservabilityConfigurationsRequest, T> g) {
        return obj -> g.apply((ListObservabilityConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppRunnerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListObservabilityConfigurationsRequest> {
        /**
         * <p>
         * The name of the App Runner observability configuration that you want to list. If specified, App Runner lists
         * revisions that share this name. If not specified, App Runner returns revisions of all active configurations.
         * </p>
         * 
         * @param observabilityConfigurationName
         *        The name of the App Runner observability configuration that you want to list. If specified, App Runner
         *        lists revisions that share this name. If not specified, App Runner returns revisions of all active
         *        configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observabilityConfigurationName(String observabilityConfigurationName);

        /**
         * <p>
         * Set to <code>true</code> to list only the latest revision for each requested configuration name.
         * </p>
         * <p>
         * Set to <code>false</code> to list all revisions for each requested configuration name.
         * </p>
         * <p>
         * Default: <code>true</code>
         * </p>
         * 
         * @param latestOnly
         *        Set to <code>true</code> to list only the latest revision for each requested configuration name.</p>
         *        <p>
         *        Set to <code>false</code> to list all revisions for each requested configuration name.
         *        </p>
         *        <p>
         *        Default: <code>true</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestOnly(Boolean latestOnly);

        /**
         * <p>
         * The maximum number of results to include in each response (result page). It's used for a paginated request.
         * </p>
         * <p>
         * If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single
         * response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in each response (result page). It's used for a paginated
         *        request.</p>
         *        <p>
         *        If you don't specify <code>MaxResults</code>, the request retrieves all available results in a single
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token from a previous result page. It's used for a paginated request. The request retrieves the next result
         * page. All other parameter values must be identical to the ones that are specified in the initial request.
         * </p>
         * <p>
         * If you don't specify <code>NextToken</code>, the request retrieves the first result page.
         * </p>
         * 
         * @param nextToken
         *        A token from a previous result page. It's used for a paginated request. The request retrieves the next
         *        result page. All other parameter values must be identical to the ones that are specified in the
         *        initial request.</p>
         *        <p>
         *        If you don't specify <code>NextToken</code>, the request retrieves the first result page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppRunnerRequest.BuilderImpl implements Builder {
        private String observabilityConfigurationName;

        private Boolean latestOnly;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObservabilityConfigurationsRequest model) {
            super(model);
            observabilityConfigurationName(model.observabilityConfigurationName);
            latestOnly(model.latestOnly);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getObservabilityConfigurationName() {
            return observabilityConfigurationName;
        }

        public final void setObservabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
        }

        @Override
        public final Builder observabilityConfigurationName(String observabilityConfigurationName) {
            this.observabilityConfigurationName = observabilityConfigurationName;
            return this;
        }

        public final Boolean getLatestOnly() {
            return latestOnly;
        }

        public final void setLatestOnly(Boolean latestOnly) {
            this.latestOnly = latestOnly;
        }

        @Override
        public final Builder latestOnly(Boolean latestOnly) {
            this.latestOnly = latestOnly;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListObservabilityConfigurationsRequest build() {
            return new ListObservabilityConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
