/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerAsyncClient;
import software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest;
import software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse;

public class ListVpcIngressConnectionsPublisher
implements SdkPublisher<ListVpcIngressConnectionsResponse> {
    private final AppRunnerAsyncClient client;
    private final ListVpcIngressConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVpcIngressConnectionsPublisher(AppRunnerAsyncClient client, ListVpcIngressConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVpcIngressConnectionsPublisher(AppRunnerAsyncClient client, ListVpcIngressConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVpcIngressConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVpcIngressConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVpcIngressConnectionsResponseFetcher
    implements AsyncPageFetcher<ListVpcIngressConnectionsResponse> {
        private ListVpcIngressConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcIngressConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVpcIngressConnectionsResponse> nextPage(ListVpcIngressConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcIngressConnectionsPublisher.this.client.listVpcIngressConnections(ListVpcIngressConnectionsPublisher.this.firstRequest);
            }
            return ListVpcIngressConnectionsPublisher.this.client.listVpcIngressConnections((ListVpcIngressConnectionsRequest)((Object)ListVpcIngressConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

