/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TracingVendor {
    AWSXRAY("AWSXRAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TracingVendor> VALUE_MAP;
    private final String value;

    private TracingVendor(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TracingVendor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TracingVendor> knownValues() {
        EnumSet<TracingVendor> knownValues = EnumSet.allOf(TracingVendor.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TracingVendor.class, TracingVendor::toString);
    }
}

