/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsRequest;
import software.amazon.awssdk.services.apprunner.model.ListVpcIngressConnectionsResponse;

public class ListVpcIngressConnectionsIterable
implements SdkIterable<ListVpcIngressConnectionsResponse> {
    private final AppRunnerClient client;
    private final ListVpcIngressConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVpcIngressConnectionsIterable(AppRunnerClient client, ListVpcIngressConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVpcIngressConnectionsResponseFetcher();
    }

    public Iterator<ListVpcIngressConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVpcIngressConnectionsResponseFetcher
    implements SyncPageFetcher<ListVpcIngressConnectionsResponse> {
        private ListVpcIngressConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcIngressConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcIngressConnectionsResponse nextPage(ListVpcIngressConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcIngressConnectionsIterable.this.client.listVpcIngressConnections(ListVpcIngressConnectionsIterable.this.firstRequest);
            }
            return ListVpcIngressConnectionsIterable.this.client.listVpcIngressConnections((ListVpcIngressConnectionsRequest)((Object)ListVpcIngressConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

