/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ImageRepositoryType {
    ECR("ECR"),
    ECR_PUBLIC("ECR_PUBLIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ImageRepositoryType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageRepositoryType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ImageRepositoryType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageRepositoryType> knownValues() {
        return Stream.of(ImageRepositoryType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

