/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateCustomDomainRequest
extends AppRunnerRequest
implements ToCopyableBuilder<Builder, AssociateCustomDomainRequest> {
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(AssociateCustomDomainRequest.getter(AssociateCustomDomainRequest::serviceArn)).setter(AssociateCustomDomainRequest.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(AssociateCustomDomainRequest.getter(AssociateCustomDomainRequest::domainName)).setter(AssociateCustomDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Boolean> ENABLE_WWW_SUBDOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableWWWSubdomain").getter(AssociateCustomDomainRequest.getter(AssociateCustomDomainRequest::enableWWWSubdomain)).setter(AssociateCustomDomainRequest.setter(Builder::enableWWWSubdomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableWWWSubdomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARN_FIELD, DOMAIN_NAME_FIELD, ENABLE_WWW_SUBDOMAIN_FIELD));
    private final String serviceArn;
    private final String domainName;
    private final Boolean enableWWWSubdomain;

    private AssociateCustomDomainRequest(BuilderImpl builder) {
        super(builder);
        this.serviceArn = builder.serviceArn;
        this.domainName = builder.domainName;
        this.enableWWWSubdomain = builder.enableWWWSubdomain;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Boolean enableWWWSubdomain() {
        return this.enableWWWSubdomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableWWWSubdomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCustomDomainRequest)) {
            return false;
        }
        AssociateCustomDomainRequest other = (AssociateCustomDomainRequest)((Object)obj);
        return Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.enableWWWSubdomain(), other.enableWWWSubdomain());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateCustomDomainRequest").add("ServiceArn", (Object)this.serviceArn()).add("DomainName", (Object)this.domainName()).add("EnableWWWSubdomain", (Object)this.enableWWWSubdomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EnableWWWSubdomain": {
                return Optional.ofNullable(clazz.cast(this.enableWWWSubdomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateCustomDomainRequest, T> g) {
        return obj -> g.apply((AssociateCustomDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerRequest.BuilderImpl
    implements Builder {
        private String serviceArn;
        private String domainName;
        private Boolean enableWWWSubdomain;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCustomDomainRequest model) {
            super(model);
            this.serviceArn(model.serviceArn);
            this.domainName(model.domainName);
            this.enableWWWSubdomain(model.enableWWWSubdomain);
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getEnableWWWSubdomain() {
            return this.enableWWWSubdomain;
        }

        public final void setEnableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
        }

        @Override
        @Transient
        public final Builder enableWWWSubdomain(Boolean enableWWWSubdomain) {
            this.enableWWWSubdomain = enableWWWSubdomain;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateCustomDomainRequest build() {
            return new AssociateCustomDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateCustomDomainRequest> {
        public Builder serviceArn(String var1);

        public Builder domainName(String var1);

        public Builder enableWWWSubdomain(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

