/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.CustomDomain;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateCustomDomainResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, AssociateCustomDomainResponse> {
    private static final SdkField<String> DNS_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSTarget").getter(AssociateCustomDomainResponse.getter(AssociateCustomDomainResponse::dnsTarget)).setter(AssociateCustomDomainResponse.setter(Builder::dnsTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSTarget").build()}).build();
    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceArn").getter(AssociateCustomDomainResponse.getter(AssociateCustomDomainResponse::serviceArn)).setter(AssociateCustomDomainResponse.setter(Builder::serviceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()}).build();
    private static final SdkField<CustomDomain> CUSTOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDomain").getter(AssociateCustomDomainResponse.getter(AssociateCustomDomainResponse::customDomain)).setter(AssociateCustomDomainResponse.setter(Builder::customDomain)).constructor(CustomDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_TARGET_FIELD, SERVICE_ARN_FIELD, CUSTOM_DOMAIN_FIELD));
    private final String dnsTarget;
    private final String serviceArn;
    private final CustomDomain customDomain;

    private AssociateCustomDomainResponse(BuilderImpl builder) {
        super(builder);
        this.dnsTarget = builder.dnsTarget;
        this.serviceArn = builder.serviceArn;
        this.customDomain = builder.customDomain;
    }

    public final String dnsTarget() {
        return this.dnsTarget;
    }

    public final String serviceArn() {
        return this.serviceArn;
    }

    public final CustomDomain customDomain() {
        return this.customDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateCustomDomainResponse)) {
            return false;
        }
        AssociateCustomDomainResponse other = (AssociateCustomDomainResponse)((Object)obj);
        return Objects.equals(this.dnsTarget(), other.dnsTarget()) && Objects.equals(this.serviceArn(), other.serviceArn()) && Objects.equals(this.customDomain(), other.customDomain());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateCustomDomainResponse").add("DNSTarget", (Object)this.dnsTarget()).add("ServiceArn", (Object)this.serviceArn()).add("CustomDomain", (Object)this.customDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DNSTarget": {
                return Optional.ofNullable(clazz.cast(this.dnsTarget()));
            }
            case "ServiceArn": {
                return Optional.ofNullable(clazz.cast(this.serviceArn()));
            }
            case "CustomDomain": {
                return Optional.ofNullable(clazz.cast(this.customDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateCustomDomainResponse, T> g) {
        return obj -> g.apply((AssociateCustomDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private String dnsTarget;
        private String serviceArn;
        private CustomDomain customDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateCustomDomainResponse model) {
            super(model);
            this.dnsTarget(model.dnsTarget);
            this.serviceArn(model.serviceArn);
            this.customDomain(model.customDomain);
        }

        public final String getDnsTarget() {
            return this.dnsTarget;
        }

        public final void setDnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
        }

        @Override
        @Transient
        public final Builder dnsTarget(String dnsTarget) {
            this.dnsTarget = dnsTarget;
            return this;
        }

        public final String getServiceArn() {
            return this.serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        @Transient
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final CustomDomain.Builder getCustomDomain() {
            return this.customDomain != null ? this.customDomain.toBuilder() : null;
        }

        public final void setCustomDomain(CustomDomain.BuilderImpl customDomain) {
            this.customDomain = customDomain != null ? customDomain.build() : null;
        }

        @Override
        @Transient
        public final Builder customDomain(CustomDomain customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        @Override
        public AssociateCustomDomainResponse build() {
            return new AssociateCustomDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateCustomDomainResponse> {
        public Builder dnsTarget(String var1);

        public Builder serviceArn(String var1);

        public Builder customDomain(CustomDomain var1);

        default public Builder customDomain(Consumer<CustomDomain.Builder> customDomain) {
            return this.customDomain((CustomDomain)((CustomDomain.Builder)CustomDomain.builder().applyMutation(customDomain)).build());
        }
    }
}

