/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apprunner.model.AppRunnerResponse;
import software.amazon.awssdk.services.apprunner.model.OperationSummary;
import software.amazon.awssdk.services.apprunner.model.OperationSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOperationsResponse
extends AppRunnerResponse
implements ToCopyableBuilder<Builder, ListOperationsResponse> {
    private static final SdkField<List<OperationSummary>> OPERATION_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OperationSummaryList").getter(ListOperationsResponse.getter(ListOperationsResponse::operationSummaryList)).setter(ListOperationsResponse.setter(Builder::operationSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOperationsResponse.getter(ListOperationsResponse::nextToken)).setter(ListOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<OperationSummary> operationSummaryList;
    private final String nextToken;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operationSummaryList = builder.operationSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasOperationSummaryList() {
        return this.operationSummaryList != null && !(this.operationSummaryList instanceof SdkAutoConstructList);
    }

    public final List<OperationSummary> operationSummaryList() {
        return this.operationSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperationSummaryList() ? this.operationSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse)((Object)obj);
        return this.hasOperationSummaryList() == other.hasOperationSummaryList() && Objects.equals(this.operationSummaryList(), other.operationSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOperationsResponse").add("OperationSummaryList", this.hasOperationSummaryList() ? this.operationSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationSummaryList": {
                return Optional.ofNullable(clazz.cast(this.operationSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsResponse, T> g) {
        return obj -> g.apply((ListOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppRunnerResponse.BuilderImpl
    implements Builder {
        private List<OperationSummary> operationSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            this.operationSummaryList(model.operationSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<OperationSummary.Builder> getOperationSummaryList() {
            List<OperationSummary.Builder> result = OperationSummaryListCopier.copyToBuilder(this.operationSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder operationSummaryList(Collection<OperationSummary> operationSummaryList) {
            this.operationSummaryList = OperationSummaryListCopier.copy(operationSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSummaryList(OperationSummary ... operationSummaryList) {
            this.operationSummaryList(Arrays.asList(operationSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSummaryList(Consumer<OperationSummary.Builder> ... operationSummaryList) {
            this.operationSummaryList(Stream.of(operationSummaryList).map(c -> (OperationSummary)((OperationSummary.Builder)OperationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperationSummaryList(Collection<OperationSummary.BuilderImpl> operationSummaryList) {
            this.operationSummaryList = OperationSummaryListCopier.copyFromBuilder(operationSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppRunnerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOperationsResponse> {
        public Builder operationSummaryList(Collection<OperationSummary> var1);

        public Builder operationSummaryList(OperationSummary ... var1);

        public Builder operationSummaryList(Consumer<OperationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

