/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Runtime {
    PYTHON_3("PYTHON_3"),
    NODEJS_12("NODEJS_12"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Runtime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Runtime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Runtime.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Runtime> knownValues() {
        return Stream.of(Runtime.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

