/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appmesh.model.HttpRouteAction;
import software.amazon.awssdk.services.appmesh.model.HttpRouteMatch;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpRoute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpRoute> {
    private static final SdkField<HttpRouteAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HttpRoute.getter(HttpRoute::action)).setter(HttpRoute.setter(Builder::action)).constructor(HttpRouteAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<HttpRouteMatch> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(HttpRoute.getter(HttpRoute::match)).setter(HttpRoute.setter(Builder::match)).constructor(HttpRouteMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD));
    private static final long serialVersionUID = 1L;
    private final HttpRouteAction action;
    private final HttpRouteMatch match;

    private HttpRoute(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
    }

    public HttpRouteAction action() {
        return this.action;
    }

    public HttpRouteMatch match() {
        return this.match;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpRoute)) {
            return false;
        }
        HttpRoute other = (HttpRoute)obj;
        return Objects.equals(this.action(), other.action()) && Objects.equals(this.match(), other.match());
    }

    public String toString() {
        return ToString.builder((String)"HttpRoute").add("Action", (Object)this.action()).add("Match", (Object)this.match()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpRoute, T> g) {
        return obj -> g.apply((HttpRoute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HttpRouteAction action;
        private HttpRouteMatch match;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpRoute model) {
            this.action(model.action);
            this.match(model.match);
        }

        public final HttpRouteAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        @Override
        public final Builder action(HttpRouteAction action) {
            this.action = action;
            return this;
        }

        public final void setAction(HttpRouteAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final HttpRouteMatch.Builder getMatch() {
            return this.match != null ? this.match.toBuilder() : null;
        }

        @Override
        public final Builder match(HttpRouteMatch match) {
            this.match = match;
            return this;
        }

        public final void setMatch(HttpRouteMatch.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        public HttpRoute build() {
            return new HttpRoute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpRoute> {
        public Builder action(HttpRouteAction var1);

        default public Builder action(Consumer<HttpRouteAction.Builder> action) {
            return this.action((HttpRouteAction)((HttpRouteAction.Builder)HttpRouteAction.builder().applyMutation(action)).build());
        }

        public Builder match(HttpRouteMatch var1);

        default public Builder match(Consumer<HttpRouteMatch.Builder> match) {
            return this.match((HttpRouteMatch)((HttpRouteMatch.Builder)HttpRouteMatch.builder().applyMutation(match)).build());
        }
    }
}

