/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.Backend;
import software.amazon.awssdk.services.appmesh.model.BackendsCopier;
import software.amazon.awssdk.services.appmesh.model.Listener;
import software.amazon.awssdk.services.appmesh.model.ListenersCopier;
import software.amazon.awssdk.services.appmesh.model.ServiceDiscovery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualNodeSpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualNodeSpec> {
    private static final SdkField<List<Backend>> BACKENDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VirtualNodeSpec.getter(VirtualNodeSpec::backends)).setter(VirtualNodeSpec.setter(Builder::backends)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backends").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Backend::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Listener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(VirtualNodeSpec.getter(VirtualNodeSpec::listeners)).setter(VirtualNodeSpec.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Listener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ServiceDiscovery> SERVICE_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(VirtualNodeSpec.getter(VirtualNodeSpec::serviceDiscovery)).setter(VirtualNodeSpec.setter(Builder::serviceDiscovery)).constructor(ServiceDiscovery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKENDS_FIELD, LISTENERS_FIELD, SERVICE_DISCOVERY_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Backend> backends;
    private final List<Listener> listeners;
    private final ServiceDiscovery serviceDiscovery;

    private VirtualNodeSpec(BuilderImpl builder) {
        this.backends = builder.backends;
        this.listeners = builder.listeners;
        this.serviceDiscovery = builder.serviceDiscovery;
    }

    public List<Backend> backends() {
        return this.backends;
    }

    public List<Listener> listeners() {
        return this.listeners;
    }

    public ServiceDiscovery serviceDiscovery() {
        return this.serviceDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backends());
        hashCode = 31 * hashCode + Objects.hashCode(this.listeners());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceDiscovery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualNodeSpec)) {
            return false;
        }
        VirtualNodeSpec other = (VirtualNodeSpec)obj;
        return Objects.equals(this.backends(), other.backends()) && Objects.equals(this.listeners(), other.listeners()) && Objects.equals(this.serviceDiscovery(), other.serviceDiscovery());
    }

    public String toString() {
        return ToString.builder((String)"VirtualNodeSpec").add("Backends", this.backends()).add("Listeners", this.listeners()).add("ServiceDiscovery", (Object)this.serviceDiscovery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "backends": {
                return Optional.ofNullable(clazz.cast(this.backends()));
            }
            case "listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
            case "serviceDiscovery": {
                return Optional.ofNullable(clazz.cast(this.serviceDiscovery()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualNodeSpec, T> g) {
        return obj -> g.apply((VirtualNodeSpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Backend> backends = DefaultSdkAutoConstructList.getInstance();
        private List<Listener> listeners = DefaultSdkAutoConstructList.getInstance();
        private ServiceDiscovery serviceDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualNodeSpec model) {
            this.backends(model.backends);
            this.listeners(model.listeners);
            this.serviceDiscovery(model.serviceDiscovery);
        }

        public final Collection<Backend.Builder> getBackends() {
            return this.backends != null ? (Collection)this.backends.stream().map(Backend::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backends(Collection<Backend> backends) {
            this.backends = BackendsCopier.copy(backends);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backends(Backend ... backends) {
            this.backends(Arrays.asList(backends));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backends(Consumer<Backend.Builder> ... backends) {
            this.backends(Stream.of(backends).map(c -> (Backend)((Backend.Builder)Backend.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBackends(Collection<Backend.BuilderImpl> backends) {
            this.backends = BackendsCopier.copyFromBuilder(backends);
        }

        public final Collection<Listener.Builder> getListeners() {
            return this.listeners != null ? (Collection)this.listeners.stream().map(Listener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<Listener> listeners) {
            this.listeners = ListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Listener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<Listener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (Listener)((Listener.Builder)Listener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<Listener.BuilderImpl> listeners) {
            this.listeners = ListenersCopier.copyFromBuilder(listeners);
        }

        public final ServiceDiscovery.Builder getServiceDiscovery() {
            return this.serviceDiscovery != null ? this.serviceDiscovery.toBuilder() : null;
        }

        @Override
        public final Builder serviceDiscovery(ServiceDiscovery serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery;
            return this;
        }

        public final void setServiceDiscovery(ServiceDiscovery.BuilderImpl serviceDiscovery) {
            this.serviceDiscovery = serviceDiscovery != null ? serviceDiscovery.build() : null;
        }

        public VirtualNodeSpec build() {
            return new VirtualNodeSpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualNodeSpec> {
        public Builder backends(Collection<Backend> var1);

        public Builder backends(Backend ... var1);

        public Builder backends(Consumer<Backend.Builder> ... var1);

        public Builder listeners(Collection<Listener> var1);

        public Builder listeners(Listener ... var1);

        public Builder listeners(Consumer<Listener.Builder> ... var1);

        public Builder serviceDiscovery(ServiceDiscovery var1);

        default public Builder serviceDiscovery(Consumer<ServiceDiscovery.Builder> serviceDiscovery) {
            return this.serviceDiscovery((ServiceDiscovery)((ServiceDiscovery.Builder)ServiceDiscovery.builder().applyMutation(serviceDiscovery)).build());
        }
    }
}

