/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteRef
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteRef> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteRef.getter(RouteRef::arn)).setter(RouteRef.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> MESH_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteRef.getter(RouteRef::meshName)).setter(RouteRef.setter(Builder::meshName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("meshName").build()}).build();
    private static final SdkField<String> ROUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteRef.getter(RouteRef::routeName)).setter(RouteRef.setter(Builder::routeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routeName").build()}).build();
    private static final SdkField<String> VIRTUAL_ROUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RouteRef.getter(RouteRef::virtualRouterName)).setter(RouteRef.setter(Builder::virtualRouterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualRouterName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, MESH_NAME_FIELD, ROUTE_NAME_FIELD, VIRTUAL_ROUTER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String meshName;
    private final String routeName;
    private final String virtualRouterName;

    private RouteRef(BuilderImpl builder) {
        this.arn = builder.arn;
        this.meshName = builder.meshName;
        this.routeName = builder.routeName;
        this.virtualRouterName = builder.virtualRouterName;
    }

    public String arn() {
        return this.arn;
    }

    public String meshName() {
        return this.meshName;
    }

    public String routeName() {
        return this.routeName;
    }

    public String virtualRouterName() {
        return this.virtualRouterName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meshName());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualRouterName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteRef)) {
            return false;
        }
        RouteRef other = (RouteRef)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.meshName(), other.meshName()) && Objects.equals(this.routeName(), other.routeName()) && Objects.equals(this.virtualRouterName(), other.virtualRouterName());
    }

    public String toString() {
        return ToString.builder((String)"RouteRef").add("Arn", (Object)this.arn()).add("MeshName", (Object)this.meshName()).add("RouteName", (Object)this.routeName()).add("VirtualRouterName", (Object)this.virtualRouterName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "meshName": {
                return Optional.ofNullable(clazz.cast(this.meshName()));
            }
            case "routeName": {
                return Optional.ofNullable(clazz.cast(this.routeName()));
            }
            case "virtualRouterName": {
                return Optional.ofNullable(clazz.cast(this.virtualRouterName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RouteRef, T> g) {
        return obj -> g.apply((RouteRef)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String meshName;
        private String routeName;
        private String virtualRouterName;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteRef model) {
            this.arn(model.arn);
            this.meshName(model.meshName);
            this.routeName(model.routeName);
            this.virtualRouterName(model.virtualRouterName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getMeshName() {
            return this.meshName;
        }

        @Override
        public final Builder meshName(String meshName) {
            this.meshName = meshName;
            return this;
        }

        public final void setMeshName(String meshName) {
            this.meshName = meshName;
        }

        public final String getRouteName() {
            return this.routeName;
        }

        @Override
        public final Builder routeName(String routeName) {
            this.routeName = routeName;
            return this;
        }

        public final void setRouteName(String routeName) {
            this.routeName = routeName;
        }

        public final String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        public final Builder virtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        public final void setVirtualRouterName(String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
        }

        public RouteRef build() {
            return new RouteRef(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteRef> {
        public Builder arn(String var1);

        public Builder meshName(String var1);

        public Builder routeName(String var1);

        public Builder virtualRouterName(String var1);
    }
}

