/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayBackendDefaults;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListener;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListenersCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayLogging;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VirtualGatewaySpec
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VirtualGatewaySpec> {
    private static final SdkField<VirtualGatewayBackendDefaults> BACKEND_DEFAULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("backendDefaults").getter(VirtualGatewaySpec.getter(VirtualGatewaySpec::backendDefaults)).setter(VirtualGatewaySpec.setter(Builder::backendDefaults)).constructor(VirtualGatewayBackendDefaults::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendDefaults").build()}).build();
    private static final SdkField<List<VirtualGatewayListener>> LISTENERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listeners").getter(VirtualGatewaySpec.getter(VirtualGatewaySpec::listeners)).setter(VirtualGatewaySpec.setter(Builder::listeners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listeners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualGatewayListener::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VirtualGatewayLogging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(VirtualGatewaySpec.getter(VirtualGatewaySpec::logging)).setter(VirtualGatewaySpec.setter(Builder::logging)).constructor(VirtualGatewayLogging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_DEFAULTS_FIELD, LISTENERS_FIELD, LOGGING_FIELD));
    private static final long serialVersionUID = 1L;
    private final VirtualGatewayBackendDefaults backendDefaults;
    private final List<VirtualGatewayListener> listeners;
    private final VirtualGatewayLogging logging;

    private VirtualGatewaySpec(BuilderImpl builder) {
        this.backendDefaults = builder.backendDefaults;
        this.listeners = builder.listeners;
        this.logging = builder.logging;
    }

    public VirtualGatewayBackendDefaults backendDefaults() {
        return this.backendDefaults;
    }

    public boolean hasListeners() {
        return this.listeners != null && !(this.listeners instanceof SdkAutoConstructList);
    }

    public List<VirtualGatewayListener> listeners() {
        return this.listeners;
    }

    public VirtualGatewayLogging logging() {
        return this.logging;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backendDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListeners() ? this.listeners() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGatewaySpec)) {
            return false;
        }
        VirtualGatewaySpec other = (VirtualGatewaySpec)obj;
        return Objects.equals(this.backendDefaults(), other.backendDefaults()) && this.hasListeners() == other.hasListeners() && Objects.equals(this.listeners(), other.listeners()) && Objects.equals(this.logging(), other.logging());
    }

    public String toString() {
        return ToString.builder((String)"VirtualGatewaySpec").add("BackendDefaults", (Object)this.backendDefaults()).add("Listeners", this.hasListeners() ? this.listeners() : null).add("Logging", (Object)this.logging()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "backendDefaults": {
                return Optional.ofNullable(clazz.cast(this.backendDefaults()));
            }
            case "listeners": {
                return Optional.ofNullable(clazz.cast(this.listeners()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VirtualGatewaySpec, T> g) {
        return obj -> g.apply((VirtualGatewaySpec)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VirtualGatewayBackendDefaults backendDefaults;
        private List<VirtualGatewayListener> listeners = DefaultSdkAutoConstructList.getInstance();
        private VirtualGatewayLogging logging;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGatewaySpec model) {
            this.backendDefaults(model.backendDefaults);
            this.listeners(model.listeners);
            this.logging(model.logging);
        }

        public final VirtualGatewayBackendDefaults.Builder getBackendDefaults() {
            return this.backendDefaults != null ? this.backendDefaults.toBuilder() : null;
        }

        @Override
        public final Builder backendDefaults(VirtualGatewayBackendDefaults backendDefaults) {
            this.backendDefaults = backendDefaults;
            return this;
        }

        public final void setBackendDefaults(VirtualGatewayBackendDefaults.BuilderImpl backendDefaults) {
            this.backendDefaults = backendDefaults != null ? backendDefaults.build() : null;
        }

        public final Collection<VirtualGatewayListener.Builder> getListeners() {
            if (this.listeners instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listeners != null ? (Collection)this.listeners.stream().map(VirtualGatewayListener::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder listeners(Collection<VirtualGatewayListener> listeners) {
            this.listeners = VirtualGatewayListenersCopier.copy(listeners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(VirtualGatewayListener ... listeners) {
            this.listeners(Arrays.asList(listeners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listeners(Consumer<VirtualGatewayListener.Builder> ... listeners) {
            this.listeners(Stream.of(listeners).map(c -> (VirtualGatewayListener)((VirtualGatewayListener.Builder)VirtualGatewayListener.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setListeners(Collection<VirtualGatewayListener.BuilderImpl> listeners) {
            this.listeners = VirtualGatewayListenersCopier.copyFromBuilder(listeners);
        }

        public final VirtualGatewayLogging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        @Override
        public final Builder logging(VirtualGatewayLogging logging) {
            this.logging = logging;
            return this;
        }

        public final void setLogging(VirtualGatewayLogging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        public VirtualGatewaySpec build() {
            return new VirtualGatewaySpec(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VirtualGatewaySpec> {
        public Builder backendDefaults(VirtualGatewayBackendDefaults var1);

        default public Builder backendDefaults(Consumer<VirtualGatewayBackendDefaults.Builder> backendDefaults) {
            return this.backendDefaults((VirtualGatewayBackendDefaults)((VirtualGatewayBackendDefaults.Builder)VirtualGatewayBackendDefaults.builder().applyMutation(backendDefaults)).build());
        }

        public Builder listeners(Collection<VirtualGatewayListener> var1);

        public Builder listeners(VirtualGatewayListener ... var1);

        public Builder listeners(Consumer<VirtualGatewayListener.Builder> ... var1);

        public Builder logging(VirtualGatewayLogging var1);

        default public Builder logging(Consumer<VirtualGatewayLogging.Builder> logging) {
            return this.logging((VirtualGatewayLogging)((VirtualGatewayLogging.Builder)VirtualGatewayLogging.builder().applyMutation(logging)).build());
        }
    }
}

