/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appmesh.model.AppMeshResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayListCopier;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVirtualGatewaysResponse
extends AppMeshResponse
implements ToCopyableBuilder<Builder, ListVirtualGatewaysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListVirtualGatewaysResponse.getter(ListVirtualGatewaysResponse::nextToken)).setter(ListVirtualGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VirtualGatewayRef>> VIRTUAL_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListVirtualGatewaysResponse.getter(ListVirtualGatewaysResponse::virtualGateways)).setter(ListVirtualGatewaysResponse.setter(Builder::virtualGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VirtualGatewayRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VIRTUAL_GATEWAYS_FIELD));
    private final String nextToken;
    private final List<VirtualGatewayRef> virtualGateways;

    private ListVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.virtualGateways = builder.virtualGateways;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasVirtualGateways() {
        return this.virtualGateways != null && !(this.virtualGateways instanceof SdkAutoConstructList);
    }

    public List<VirtualGatewayRef> virtualGateways() {
        return this.virtualGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualGateways());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualGatewaysResponse)) {
            return false;
        }
        ListVirtualGatewaysResponse other = (ListVirtualGatewaysResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.virtualGateways(), other.virtualGateways());
    }

    public String toString() {
        return ToString.builder((String)"ListVirtualGatewaysResponse").add("NextToken", (Object)this.nextToken()).add("VirtualGateways", this.virtualGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "virtualGateways": {
                return Optional.ofNullable(clazz.cast(this.virtualGateways()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualGatewaysResponse, T> g) {
        return obj -> g.apply((ListVirtualGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppMeshResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VirtualGatewayRef> virtualGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualGatewaysResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.virtualGateways(model.virtualGateways);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VirtualGatewayRef.Builder> getVirtualGateways() {
            return this.virtualGateways != null ? (Collection)this.virtualGateways.stream().map(VirtualGatewayRef::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGatewayRef> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGatewayRef ... virtualGateways) {
            this.virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(Consumer<VirtualGatewayRef.Builder> ... virtualGateways) {
            this.virtualGateways(Stream.of(virtualGateways).map(c -> (VirtualGatewayRef)((VirtualGatewayRef.Builder)VirtualGatewayRef.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualGateways(Collection<VirtualGatewayRef.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public ListVirtualGatewaysResponse build() {
            return new ListVirtualGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppMeshResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVirtualGatewaysResponse> {
        public Builder nextToken(String var1);

        public Builder virtualGateways(Collection<VirtualGatewayRef> var1);

        public Builder virtualGateways(VirtualGatewayRef ... var1);

        public Builder virtualGateways(Consumer<VirtualGatewayRef.Builder> ... var1);
    }
}

