/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationdiscovery.model.FileClassification;
import software.amazon.awssdk.services.applicationdiscovery.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportTask> {
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importTaskId").getter(ImportTask.getter(ImportTask::importTaskId)).setter(ImportTask.setter(Builder::importTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(ImportTask.getter(ImportTask::clientRequestToken)).setter(ImportTask.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImportTask.getter(ImportTask::name)).setter(ImportTask.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> IMPORT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importUrl").getter(ImportTask.getter(ImportTask::importUrl)).setter(ImportTask.setter(Builder::importUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importUrl").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImportTask.getter(ImportTask::statusAsString)).setter(ImportTask.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> IMPORT_REQUEST_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("importRequestTime").getter(ImportTask.getter(ImportTask::importRequestTime)).setter(ImportTask.setter(Builder::importRequestTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importRequestTime").build()}).build();
    private static final SdkField<Instant> IMPORT_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("importCompletionTime").getter(ImportTask.getter(ImportTask::importCompletionTime)).setter(ImportTask.setter(Builder::importCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importCompletionTime").build()}).build();
    private static final SdkField<Instant> IMPORT_DELETED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("importDeletedTime").getter(ImportTask.getter(ImportTask::importDeletedTime)).setter(ImportTask.setter(Builder::importDeletedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDeletedTime").build()}).build();
    private static final SdkField<String> FILE_CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileClassification").getter(ImportTask.getter(ImportTask::fileClassificationAsString)).setter(ImportTask.setter(Builder::fileClassification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileClassification").build()}).build();
    private static final SdkField<Integer> SERVER_IMPORT_SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("serverImportSuccess").getter(ImportTask.getter(ImportTask::serverImportSuccess)).setter(ImportTask.setter(Builder::serverImportSuccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverImportSuccess").build()}).build();
    private static final SdkField<Integer> SERVER_IMPORT_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("serverImportFailure").getter(ImportTask.getter(ImportTask::serverImportFailure)).setter(ImportTask.setter(Builder::serverImportFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverImportFailure").build()}).build();
    private static final SdkField<Integer> APPLICATION_IMPORT_SUCCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("applicationImportSuccess").getter(ImportTask.getter(ImportTask::applicationImportSuccess)).setter(ImportTask.setter(Builder::applicationImportSuccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationImportSuccess").build()}).build();
    private static final SdkField<Integer> APPLICATION_IMPORT_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("applicationImportFailure").getter(ImportTask.getter(ImportTask::applicationImportFailure)).setter(ImportTask.setter(Builder::applicationImportFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationImportFailure").build()}).build();
    private static final SdkField<String> ERRORS_AND_FAILED_ENTRIES_ZIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorsAndFailedEntriesZip").getter(ImportTask.getter(ImportTask::errorsAndFailedEntriesZip)).setter(ImportTask.setter(Builder::errorsAndFailedEntriesZip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorsAndFailedEntriesZip").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, NAME_FIELD, IMPORT_URL_FIELD, STATUS_FIELD, IMPORT_REQUEST_TIME_FIELD, IMPORT_COMPLETION_TIME_FIELD, IMPORT_DELETED_TIME_FIELD, FILE_CLASSIFICATION_FIELD, SERVER_IMPORT_SUCCESS_FIELD, SERVER_IMPORT_FAILURE_FIELD, APPLICATION_IMPORT_SUCCESS_FIELD, APPLICATION_IMPORT_FAILURE_FIELD, ERRORS_AND_FAILED_ENTRIES_ZIP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImportTask.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String importTaskId;
    private final String clientRequestToken;
    private final String name;
    private final String importUrl;
    private final String status;
    private final Instant importRequestTime;
    private final Instant importCompletionTime;
    private final Instant importDeletedTime;
    private final String fileClassification;
    private final Integer serverImportSuccess;
    private final Integer serverImportFailure;
    private final Integer applicationImportSuccess;
    private final Integer applicationImportFailure;
    private final String errorsAndFailedEntriesZip;

    private ImportTask(BuilderImpl builder) {
        this.importTaskId = builder.importTaskId;
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.importUrl = builder.importUrl;
        this.status = builder.status;
        this.importRequestTime = builder.importRequestTime;
        this.importCompletionTime = builder.importCompletionTime;
        this.importDeletedTime = builder.importDeletedTime;
        this.fileClassification = builder.fileClassification;
        this.serverImportSuccess = builder.serverImportSuccess;
        this.serverImportFailure = builder.serverImportFailure;
        this.applicationImportSuccess = builder.applicationImportSuccess;
        this.applicationImportFailure = builder.applicationImportFailure;
        this.errorsAndFailedEntriesZip = builder.errorsAndFailedEntriesZip;
    }

    public final String importTaskId() {
        return this.importTaskId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String name() {
        return this.name;
    }

    public final String importUrl() {
        return this.importUrl;
    }

    public final ImportStatus status() {
        return ImportStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant importRequestTime() {
        return this.importRequestTime;
    }

    public final Instant importCompletionTime() {
        return this.importCompletionTime;
    }

    public final Instant importDeletedTime() {
        return this.importDeletedTime;
    }

    public final FileClassification fileClassification() {
        return FileClassification.fromValue(this.fileClassification);
    }

    public final String fileClassificationAsString() {
        return this.fileClassification;
    }

    public final Integer serverImportSuccess() {
        return this.serverImportSuccess;
    }

    public final Integer serverImportFailure() {
        return this.serverImportFailure;
    }

    public final Integer applicationImportSuccess() {
        return this.applicationImportSuccess;
    }

    public final Integer applicationImportFailure() {
        return this.applicationImportFailure;
    }

    public final String errorsAndFailedEntriesZip() {
        return this.errorsAndFailedEntriesZip;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.importUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importRequestTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDeletedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileClassificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverImportSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverImportFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationImportSuccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationImportFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorsAndFailedEntriesZip());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTask)) {
            return false;
        }
        ImportTask other = (ImportTask)obj;
        return Objects.equals(this.importTaskId(), other.importTaskId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.importUrl(), other.importUrl()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.importRequestTime(), other.importRequestTime()) && Objects.equals(this.importCompletionTime(), other.importCompletionTime()) && Objects.equals(this.importDeletedTime(), other.importDeletedTime()) && Objects.equals(this.fileClassificationAsString(), other.fileClassificationAsString()) && Objects.equals(this.serverImportSuccess(), other.serverImportSuccess()) && Objects.equals(this.serverImportFailure(), other.serverImportFailure()) && Objects.equals(this.applicationImportSuccess(), other.applicationImportSuccess()) && Objects.equals(this.applicationImportFailure(), other.applicationImportFailure()) && Objects.equals(this.errorsAndFailedEntriesZip(), other.errorsAndFailedEntriesZip());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTask").add("ImportTaskId", (Object)this.importTaskId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Name", (Object)this.name()).add("ImportUrl", (Object)this.importUrl()).add("Status", (Object)this.statusAsString()).add("ImportRequestTime", (Object)this.importRequestTime()).add("ImportCompletionTime", (Object)this.importCompletionTime()).add("ImportDeletedTime", (Object)this.importDeletedTime()).add("FileClassification", (Object)this.fileClassificationAsString()).add("ServerImportSuccess", (Object)this.serverImportSuccess()).add("ServerImportFailure", (Object)this.serverImportFailure()).add("ApplicationImportSuccess", (Object)this.applicationImportSuccess()).add("ApplicationImportFailure", (Object)this.applicationImportFailure()).add("ErrorsAndFailedEntriesZip", (Object)this.errorsAndFailedEntriesZip()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importTaskId": {
                return Optional.ofNullable(clazz.cast(this.importTaskId()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "importUrl": {
                return Optional.ofNullable(clazz.cast(this.importUrl()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "importRequestTime": {
                return Optional.ofNullable(clazz.cast(this.importRequestTime()));
            }
            case "importCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.importCompletionTime()));
            }
            case "importDeletedTime": {
                return Optional.ofNullable(clazz.cast(this.importDeletedTime()));
            }
            case "fileClassification": {
                return Optional.ofNullable(clazz.cast(this.fileClassificationAsString()));
            }
            case "serverImportSuccess": {
                return Optional.ofNullable(clazz.cast(this.serverImportSuccess()));
            }
            case "serverImportFailure": {
                return Optional.ofNullable(clazz.cast(this.serverImportFailure()));
            }
            case "applicationImportSuccess": {
                return Optional.ofNullable(clazz.cast(this.applicationImportSuccess()));
            }
            case "applicationImportFailure": {
                return Optional.ofNullable(clazz.cast(this.applicationImportFailure()));
            }
            case "errorsAndFailedEntriesZip": {
                return Optional.ofNullable(clazz.cast(this.errorsAndFailedEntriesZip()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importTaskId", IMPORT_TASK_ID_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("importUrl", IMPORT_URL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("importRequestTime", IMPORT_REQUEST_TIME_FIELD);
        map.put("importCompletionTime", IMPORT_COMPLETION_TIME_FIELD);
        map.put("importDeletedTime", IMPORT_DELETED_TIME_FIELD);
        map.put("fileClassification", FILE_CLASSIFICATION_FIELD);
        map.put("serverImportSuccess", SERVER_IMPORT_SUCCESS_FIELD);
        map.put("serverImportFailure", SERVER_IMPORT_FAILURE_FIELD);
        map.put("applicationImportSuccess", APPLICATION_IMPORT_SUCCESS_FIELD);
        map.put("applicationImportFailure", APPLICATION_IMPORT_FAILURE_FIELD);
        map.put("errorsAndFailedEntriesZip", ERRORS_AND_FAILED_ENTRIES_ZIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportTask, T> g) {
        return obj -> g.apply((ImportTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importTaskId;
        private String clientRequestToken;
        private String name;
        private String importUrl;
        private String status;
        private Instant importRequestTime;
        private Instant importCompletionTime;
        private Instant importDeletedTime;
        private String fileClassification;
        private Integer serverImportSuccess;
        private Integer serverImportFailure;
        private Integer applicationImportSuccess;
        private Integer applicationImportFailure;
        private String errorsAndFailedEntriesZip;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTask model) {
            this.importTaskId(model.importTaskId);
            this.clientRequestToken(model.clientRequestToken);
            this.name(model.name);
            this.importUrl(model.importUrl);
            this.status(model.status);
            this.importRequestTime(model.importRequestTime);
            this.importCompletionTime(model.importCompletionTime);
            this.importDeletedTime(model.importDeletedTime);
            this.fileClassification(model.fileClassification);
            this.serverImportSuccess(model.serverImportSuccess);
            this.serverImportFailure(model.serverImportFailure);
            this.applicationImportSuccess(model.applicationImportSuccess);
            this.applicationImportFailure(model.applicationImportFailure);
            this.errorsAndFailedEntriesZip(model.errorsAndFailedEntriesZip);
        }

        public final String getImportTaskId() {
            return this.importTaskId;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImportUrl() {
            return this.importUrl;
        }

        public final void setImportUrl(String importUrl) {
            this.importUrl = importUrl;
        }

        @Override
        public final Builder importUrl(String importUrl) {
            this.importUrl = importUrl;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getImportRequestTime() {
            return this.importRequestTime;
        }

        public final void setImportRequestTime(Instant importRequestTime) {
            this.importRequestTime = importRequestTime;
        }

        @Override
        public final Builder importRequestTime(Instant importRequestTime) {
            this.importRequestTime = importRequestTime;
            return this;
        }

        public final Instant getImportCompletionTime() {
            return this.importCompletionTime;
        }

        public final void setImportCompletionTime(Instant importCompletionTime) {
            this.importCompletionTime = importCompletionTime;
        }

        @Override
        public final Builder importCompletionTime(Instant importCompletionTime) {
            this.importCompletionTime = importCompletionTime;
            return this;
        }

        public final Instant getImportDeletedTime() {
            return this.importDeletedTime;
        }

        public final void setImportDeletedTime(Instant importDeletedTime) {
            this.importDeletedTime = importDeletedTime;
        }

        @Override
        public final Builder importDeletedTime(Instant importDeletedTime) {
            this.importDeletedTime = importDeletedTime;
            return this;
        }

        public final String getFileClassification() {
            return this.fileClassification;
        }

        public final void setFileClassification(String fileClassification) {
            this.fileClassification = fileClassification;
        }

        @Override
        public final Builder fileClassification(String fileClassification) {
            this.fileClassification = fileClassification;
            return this;
        }

        @Override
        public final Builder fileClassification(FileClassification fileClassification) {
            this.fileClassification(fileClassification == null ? null : fileClassification.toString());
            return this;
        }

        public final Integer getServerImportSuccess() {
            return this.serverImportSuccess;
        }

        public final void setServerImportSuccess(Integer serverImportSuccess) {
            this.serverImportSuccess = serverImportSuccess;
        }

        @Override
        public final Builder serverImportSuccess(Integer serverImportSuccess) {
            this.serverImportSuccess = serverImportSuccess;
            return this;
        }

        public final Integer getServerImportFailure() {
            return this.serverImportFailure;
        }

        public final void setServerImportFailure(Integer serverImportFailure) {
            this.serverImportFailure = serverImportFailure;
        }

        @Override
        public final Builder serverImportFailure(Integer serverImportFailure) {
            this.serverImportFailure = serverImportFailure;
            return this;
        }

        public final Integer getApplicationImportSuccess() {
            return this.applicationImportSuccess;
        }

        public final void setApplicationImportSuccess(Integer applicationImportSuccess) {
            this.applicationImportSuccess = applicationImportSuccess;
        }

        @Override
        public final Builder applicationImportSuccess(Integer applicationImportSuccess) {
            this.applicationImportSuccess = applicationImportSuccess;
            return this;
        }

        public final Integer getApplicationImportFailure() {
            return this.applicationImportFailure;
        }

        public final void setApplicationImportFailure(Integer applicationImportFailure) {
            this.applicationImportFailure = applicationImportFailure;
        }

        @Override
        public final Builder applicationImportFailure(Integer applicationImportFailure) {
            this.applicationImportFailure = applicationImportFailure;
            return this;
        }

        public final String getErrorsAndFailedEntriesZip() {
            return this.errorsAndFailedEntriesZip;
        }

        public final void setErrorsAndFailedEntriesZip(String errorsAndFailedEntriesZip) {
            this.errorsAndFailedEntriesZip = errorsAndFailedEntriesZip;
        }

        @Override
        public final Builder errorsAndFailedEntriesZip(String errorsAndFailedEntriesZip) {
            this.errorsAndFailedEntriesZip = errorsAndFailedEntriesZip;
            return this;
        }

        public ImportTask build() {
            return new ImportTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportTask> {
        public Builder importTaskId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder name(String var1);

        public Builder importUrl(String var1);

        public Builder status(String var1);

        public Builder status(ImportStatus var1);

        public Builder importRequestTime(Instant var1);

        public Builder importCompletionTime(Instant var1);

        public Builder importDeletedTime(Instant var1);

        public Builder fileClassification(String var1);

        public Builder fileClassification(FileClassification var1);

        public Builder serverImportSuccess(Integer var1);

        public Builder serverImportFailure(Integer var1);

        public Builder applicationImportSuccess(Integer var1);

        public Builder applicationImportFailure(Integer var1);

        public Builder errorsAndFailedEntriesZip(String var1);
    }
}

