/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.ContinuousExportDescription;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeContinuousExportsResponse;

public class DescribeContinuousExportsPublisher
implements SdkPublisher<DescribeContinuousExportsResponse> {
    private final ApplicationDiscoveryAsyncClient client;
    private final DescribeContinuousExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeContinuousExportsPublisher(ApplicationDiscoveryAsyncClient client, DescribeContinuousExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeContinuousExportsPublisher(ApplicationDiscoveryAsyncClient client, DescribeContinuousExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeContinuousExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeContinuousExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContinuousExportDescription> descriptions() {
        Function<DescribeContinuousExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.descriptions() != null) {
                return response.descriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeContinuousExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeContinuousExportsResponseFetcher
    implements AsyncPageFetcher<DescribeContinuousExportsResponse> {
        private DescribeContinuousExportsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeContinuousExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeContinuousExportsResponse> nextPage(DescribeContinuousExportsResponse previousPage) {
            if (previousPage == null) {
                return DescribeContinuousExportsPublisher.this.client.describeContinuousExports(DescribeContinuousExportsPublisher.this.firstRequest);
            }
            return DescribeContinuousExportsPublisher.this.client.describeContinuousExports((DescribeContinuousExportsRequest)((Object)DescribeContinuousExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

