/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateConfigurationItemsToApplicationRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, AssociateConfigurationItemsToApplicationRequest> {
    private static final SdkField<String> APPLICATION_CONFIGURATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationConfigurationId").getter(AssociateConfigurationItemsToApplicationRequest.getter(AssociateConfigurationItemsToApplicationRequest::applicationConfigurationId)).setter(AssociateConfigurationItemsToApplicationRequest.setter(Builder::applicationConfigurationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationConfigurationId").build()}).build();
    private static final SdkField<List<String>> CONFIGURATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationIds").getter(AssociateConfigurationItemsToApplicationRequest.getter(AssociateConfigurationItemsToApplicationRequest::configurationIds)).setter(AssociateConfigurationItemsToApplicationRequest.setter(Builder::configurationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_CONFIGURATION_ID_FIELD, CONFIGURATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationConfigurationId", APPLICATION_CONFIGURATION_ID_FIELD);
            this.put("configurationIds", CONFIGURATION_IDS_FIELD);
        }
    });
    private final String applicationConfigurationId;
    private final List<String> configurationIds;

    private AssociateConfigurationItemsToApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationConfigurationId = builder.applicationConfigurationId;
        this.configurationIds = builder.configurationIds;
    }

    public final String applicationConfigurationId() {
        return this.applicationConfigurationId;
    }

    public final boolean hasConfigurationIds() {
        return this.configurationIds != null && !(this.configurationIds instanceof SdkAutoConstructList);
    }

    public final List<String> configurationIds() {
        return this.configurationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationIds() ? this.configurationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateConfigurationItemsToApplicationRequest)) {
            return false;
        }
        AssociateConfigurationItemsToApplicationRequest other = (AssociateConfigurationItemsToApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationConfigurationId(), other.applicationConfigurationId()) && this.hasConfigurationIds() == other.hasConfigurationIds() && Objects.equals(this.configurationIds(), other.configurationIds());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateConfigurationItemsToApplicationRequest").add("ApplicationConfigurationId", (Object)this.applicationConfigurationId()).add("ConfigurationIds", this.hasConfigurationIds() ? this.configurationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationConfigurationId": {
                return Optional.ofNullable(clazz.cast(this.applicationConfigurationId()));
            }
            case "configurationIds": {
                return Optional.ofNullable(clazz.cast(this.configurationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssociateConfigurationItemsToApplicationRequest, T> g) {
        return obj -> g.apply((AssociateConfigurationItemsToApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String applicationConfigurationId;
        private List<String> configurationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateConfigurationItemsToApplicationRequest model) {
            super(model);
            this.applicationConfigurationId(model.applicationConfigurationId);
            this.configurationIds(model.configurationIds);
        }

        public final String getApplicationConfigurationId() {
            return this.applicationConfigurationId;
        }

        public final void setApplicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
        }

        @Override
        public final Builder applicationConfigurationId(String applicationConfigurationId) {
            this.applicationConfigurationId = applicationConfigurationId;
            return this;
        }

        public final Collection<String> getConfigurationIds() {
            if (this.configurationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationIds;
        }

        public final void setConfigurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
        }

        @Override
        public final Builder configurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationIds(String ... configurationIds) {
            this.configurationIds(Arrays.asList(configurationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateConfigurationItemsToApplicationRequest build() {
            return new AssociateConfigurationItemsToApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateConfigurationItemsToApplicationRequest> {
        public Builder applicationConfigurationId(String var1);

        public Builder configurationIds(Collection<String> var1);

        public Builder configurationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

