/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ConfigurationIdListCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.DeletionConfigurationItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartBatchDeleteConfigurationTaskRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, StartBatchDeleteConfigurationTaskRequest> {
    private static final SdkField<String> CONFIGURATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configurationType").getter(StartBatchDeleteConfigurationTaskRequest.getter(StartBatchDeleteConfigurationTaskRequest::configurationTypeAsString)).setter(StartBatchDeleteConfigurationTaskRequest.setter(Builder::configurationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationType").build()}).build();
    private static final SdkField<List<String>> CONFIGURATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationIds").getter(StartBatchDeleteConfigurationTaskRequest.getter(StartBatchDeleteConfigurationTaskRequest::configurationIds)).setter(StartBatchDeleteConfigurationTaskRequest.setter(Builder::configurationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TYPE_FIELD, CONFIGURATION_IDS_FIELD));
    private final String configurationType;
    private final List<String> configurationIds;

    private StartBatchDeleteConfigurationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.configurationType = builder.configurationType;
        this.configurationIds = builder.configurationIds;
    }

    public final DeletionConfigurationItemType configurationType() {
        return DeletionConfigurationItemType.fromValue(this.configurationType);
    }

    public final String configurationTypeAsString() {
        return this.configurationType;
    }

    public final boolean hasConfigurationIds() {
        return this.configurationIds != null && !(this.configurationIds instanceof SdkAutoConstructList);
    }

    public final List<String> configurationIds() {
        return this.configurationIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationIds() ? this.configurationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartBatchDeleteConfigurationTaskRequest)) {
            return false;
        }
        StartBatchDeleteConfigurationTaskRequest other = (StartBatchDeleteConfigurationTaskRequest)((Object)obj);
        return Objects.equals(this.configurationTypeAsString(), other.configurationTypeAsString()) && this.hasConfigurationIds() == other.hasConfigurationIds() && Objects.equals(this.configurationIds(), other.configurationIds());
    }

    public final String toString() {
        return ToString.builder((String)"StartBatchDeleteConfigurationTaskRequest").add("ConfigurationType", (Object)this.configurationTypeAsString()).add("ConfigurationIds", this.hasConfigurationIds() ? this.configurationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationType": {
                return Optional.ofNullable(clazz.cast(this.configurationTypeAsString()));
            }
            case "configurationIds": {
                return Optional.ofNullable(clazz.cast(this.configurationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartBatchDeleteConfigurationTaskRequest, T> g) {
        return obj -> g.apply((StartBatchDeleteConfigurationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private String configurationType;
        private List<String> configurationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartBatchDeleteConfigurationTaskRequest model) {
            super(model);
            this.configurationType(model.configurationType);
            this.configurationIds(model.configurationIds);
        }

        public final String getConfigurationType() {
            return this.configurationType;
        }

        public final void setConfigurationType(String configurationType) {
            this.configurationType = configurationType;
        }

        @Override
        public final Builder configurationType(String configurationType) {
            this.configurationType = configurationType;
            return this;
        }

        @Override
        public final Builder configurationType(DeletionConfigurationItemType configurationType) {
            this.configurationType(configurationType == null ? null : configurationType.toString());
            return this;
        }

        public final Collection<String> getConfigurationIds() {
            if (this.configurationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.configurationIds;
        }

        public final void setConfigurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
        }

        @Override
        public final Builder configurationIds(Collection<String> configurationIds) {
            this.configurationIds = ConfigurationIdListCopier.copy(configurationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationIds(String ... configurationIds) {
            this.configurationIds(Arrays.asList(configurationIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartBatchDeleteConfigurationTaskRequest build() {
            return new StartBatchDeleteConfigurationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartBatchDeleteConfigurationTaskRequest> {
        public Builder configurationType(String var1);

        public Builder configurationType(DeletionConfigurationItemType var1);

        public Builder configurationIds(Collection<String> var1);

        public Builder configurationIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

