/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteAgentError;
import software.amazon.awssdk.services.applicationdiscovery.model.BatchDeleteAgentErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteAgentsResponse
extends ApplicationDiscoveryResponse
implements ToCopyableBuilder<Builder, BatchDeleteAgentsResponse> {
    private static final SdkField<List<BatchDeleteAgentError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchDeleteAgentsResponse.getter(BatchDeleteAgentsResponse::errors)).setter(BatchDeleteAgentsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDeleteAgentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));
    private final List<BatchDeleteAgentError> errors;

    private BatchDeleteAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDeleteAgentError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteAgentsResponse)) {
            return false;
        }
        BatchDeleteAgentsResponse other = (BatchDeleteAgentsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDeleteAgentsResponse").add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteAgentsResponse, T> g) {
        return obj -> g.apply((BatchDeleteAgentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryResponse.BuilderImpl
    implements Builder {
        private List<BatchDeleteAgentError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteAgentsResponse model) {
            super(model);
            this.errors(model.errors);
        }

        public final List<BatchDeleteAgentError.Builder> getErrors() {
            List<BatchDeleteAgentError.Builder> result = BatchDeleteAgentErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDeleteAgentError.BuilderImpl> errors) {
            this.errors = BatchDeleteAgentErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDeleteAgentError> errors) {
            this.errors = BatchDeleteAgentErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDeleteAgentError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDeleteAgentError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDeleteAgentError)((BatchDeleteAgentError.Builder)BatchDeleteAgentError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDeleteAgentsResponse build() {
            return new BatchDeleteAgentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDeleteAgentsResponse> {
        public Builder errors(Collection<BatchDeleteAgentError> var1);

        public Builder errors(BatchDeleteAgentError ... var1);

        public Builder errors(Consumer<BatchDeleteAgentError.Builder> ... var1);
    }
}

