/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImportStatus {
    IMPORT_IN_PROGRESS("IMPORT_IN_PROGRESS"),
    IMPORT_COMPLETE("IMPORT_COMPLETE"),
    IMPORT_COMPLETE_WITH_ERRORS("IMPORT_COMPLETE_WITH_ERRORS"),
    IMPORT_FAILED("IMPORT_FAILED"),
    IMPORT_FAILED_SERVER_LIMIT_EXCEEDED("IMPORT_FAILED_SERVER_LIMIT_EXCEEDED"),
    IMPORT_FAILED_RECORD_LIMIT_EXCEEDED("IMPORT_FAILED_RECORD_LIMIT_EXCEEDED"),
    DELETE_IN_PROGRESS("DELETE_IN_PROGRESS"),
    DELETE_COMPLETE("DELETE_COMPLETE"),
    DELETE_FAILED("DELETE_FAILED"),
    DELETE_FAILED_LIMIT_EXCEEDED("DELETE_FAILED_LIMIT_EXCEEDED"),
    INTERNAL_ERROR("INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImportStatus> VALUE_MAP;
    private final String value;

    private ImportStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImportStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImportStatus> knownValues() {
        EnumSet<ImportStatus> knownValues = EnumSet.allOf(ImportStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImportStatus.class, ImportStatus::toString);
    }
}

