/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExportDataFormat {
    CSV("CSV"),
    GRAPHML("GRAPHML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExportDataFormat> VALUE_MAP;
    private final String value;

    private ExportDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportDataFormat> knownValues() {
        EnumSet<ExportDataFormat> knownValues = EnumSet.allOf(ExportDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExportDataFormat.class, ExportDataFormat::toString);
    }
}

