/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImportTasksRequest extends ApplicationDiscoveryRequest implements
        ToCopyableBuilder<DescribeImportTasksRequest.Builder, DescribeImportTasksRequest> {
    private static final SdkField<List<ImportTaskFilter>> FILTERS_FIELD = SdkField
            .<List<ImportTaskFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(DescribeImportTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImportTaskFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImportTaskFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(DescribeImportTasksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(DescribeImportTasksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ImportTaskFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeImportTasksRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code>
     * request to a specific subset of results. Currently, wildcard values aren't supported for filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of name-value pairs that you provide to filter the results for the
     *         <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values
     *         aren't supported for filters.
     */
    public final List<ImportTaskFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of results that you want this request to return, up to 100.
     * </p>
     * 
     * @return The maximum number of results that you want this request to return, up to 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to request a specific page of results.
     * </p>
     * 
     * @return The token to request a specific page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportTasksRequest)) {
            return false;
        }
        DescribeImportTasksRequest other = (DescribeImportTasksRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImportTasksRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportTasksRequest, T> g) {
        return obj -> g.apply((DescribeImportTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeImportTasksRequest> {
        /**
         * <p>
         * An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code>
         * request to a specific subset of results. Currently, wildcard values aren't supported for filters.
         * </p>
         * 
         * @param filters
         *        An array of name-value pairs that you provide to filter the results for the
         *        <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values
         *        aren't supported for filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ImportTaskFilter> filters);

        /**
         * <p>
         * An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code>
         * request to a specific subset of results. Currently, wildcard values aren't supported for filters.
         * </p>
         * 
         * @param filters
         *        An array of name-value pairs that you provide to filter the results for the
         *        <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values
         *        aren't supported for filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ImportTaskFilter... filters);

        /**
         * <p>
         * An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code>
         * request to a specific subset of results. Currently, wildcard values aren't supported for filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ImportTaskFilter>.Builder} avoiding the
         * need to create one manually via {@link List<ImportTaskFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ImportTaskFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ImportTaskFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ImportTaskFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ImportTaskFilter>)
         */
        Builder filters(Consumer<ImportTaskFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of results that you want this request to return, up to 100.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results that you want this request to return, up to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to request a specific page of results.
         * </p>
         * 
         * @param nextToken
         *        The token to request a specific page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApplicationDiscoveryRequest.BuilderImpl implements Builder {
        private List<ImportTaskFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportTasksRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<ImportTaskFilter.Builder> getFilters() {
            if (filters instanceof SdkAutoConstructList) {
                return null;
            }
            return filters != null ? filters.stream().map(ImportTaskFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ImportTaskFilter> filters) {
            this.filters = DescribeImportTasksFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ImportTaskFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ImportTaskFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ImportTaskFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ImportTaskFilter.BuilderImpl> filters) {
            this.filters = DescribeImportTasksFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImportTasksRequest build() {
            return new DescribeImportTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
