/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error messages returned for each import task that you deleted as a response for this command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteImportDataError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteImportDataError.Builder, BatchDeleteImportDataError> {
    private static final SdkField<String> IMPORT_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("importTaskId").getter(getter(BatchDeleteImportDataError::importTaskId))
            .setter(setter(Builder::importTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importTaskId").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchDeleteImportDataError::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDescription").getter(getter(BatchDeleteImportDataError::errorDescription))
            .setter(setter(Builder::errorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDescription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_TASK_ID_FIELD,
            ERROR_CODE_FIELD, ERROR_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String importTaskId;

    private final String errorCode;

    private final String errorDescription;

    private BatchDeleteImportDataError(BuilderImpl builder) {
        this.importTaskId = builder.importTaskId;
        this.errorCode = builder.errorCode;
        this.errorDescription = builder.errorDescription;
    }

    /**
     * <p>
     * The unique import ID associated with the error that occurred.
     * </p>
     * 
     * @return The unique import ID associated with the error that occurred.
     */
    public final String importTaskId() {
        return importTaskId;
    }

    /**
     * <p>
     * The type of error that occurred for a specific import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchDeleteImportDataErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The type of error that occurred for a specific import task.
     * @see BatchDeleteImportDataErrorCode
     */
    public final BatchDeleteImportDataErrorCode errorCode() {
        return BatchDeleteImportDataErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The type of error that occurred for a specific import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchDeleteImportDataErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The type of error that occurred for a specific import task.
     * @see BatchDeleteImportDataErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The description of the error that occurred for a specific import task.
     * </p>
     * 
     * @return The description of the error that occurred for a specific import task.
     */
    public final String errorDescription() {
        return errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(importTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImportDataError)) {
            return false;
        }
        BatchDeleteImportDataError other = (BatchDeleteImportDataError) obj;
        return Objects.equals(importTaskId(), other.importTaskId())
                && Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorDescription(), other.errorDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteImportDataError").add("ImportTaskId", importTaskId())
                .add("ErrorCode", errorCodeAsString()).add("ErrorDescription", errorDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importTaskId":
            return Optional.ofNullable(clazz.cast(importTaskId()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorDescription":
            return Optional.ofNullable(clazz.cast(errorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteImportDataError, T> g) {
        return obj -> g.apply((BatchDeleteImportDataError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteImportDataError> {
        /**
         * <p>
         * The unique import ID associated with the error that occurred.
         * </p>
         * 
         * @param importTaskId
         *        The unique import ID associated with the error that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importTaskId(String importTaskId);

        /**
         * <p>
         * The type of error that occurred for a specific import task.
         * </p>
         * 
         * @param errorCode
         *        The type of error that occurred for a specific import task.
         * @see BatchDeleteImportDataErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteImportDataErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The type of error that occurred for a specific import task.
         * </p>
         * 
         * @param errorCode
         *        The type of error that occurred for a specific import task.
         * @see BatchDeleteImportDataErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchDeleteImportDataErrorCode
         */
        Builder errorCode(BatchDeleteImportDataErrorCode errorCode);

        /**
         * <p>
         * The description of the error that occurred for a specific import task.
         * </p>
         * 
         * @param errorDescription
         *        The description of the error that occurred for a specific import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDescription(String errorDescription);
    }

    static final class BuilderImpl implements Builder {
        private String importTaskId;

        private String errorCode;

        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImportDataError model) {
            importTaskId(model.importTaskId);
            errorCode(model.errorCode);
            errorDescription(model.errorDescription);
        }

        public final String getImportTaskId() {
            return importTaskId;
        }

        @Override
        public final Builder importTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
            return this;
        }

        public final void setImportTaskId(String importTaskId) {
            this.importTaskId = importTaskId;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchDeleteImportDataErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorDescription() {
            return errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public BatchDeleteImportDataError build() {
            return new BatchDeleteImportDataError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
