/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServerNeighborsResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<ListServerNeighborsResponse.Builder, ListServerNeighborsResponse> {
    private static final SdkField<List<NeighborConnectionDetail>> NEIGHBORS_FIELD = SdkField
            .<List<NeighborConnectionDetail>> builder(MarshallingType.LIST)
            .getter(getter(ListServerNeighborsResponse::neighbors))
            .setter(setter(Builder::neighbors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neighbors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NeighborConnectionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(NeighborConnectionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServerNeighborsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Long> KNOWN_DEPENDENCY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(ListServerNeighborsResponse::knownDependencyCount)).setter(setter(Builder::knownDependencyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knownDependencyCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEIGHBORS_FIELD,
            NEXT_TOKEN_FIELD, KNOWN_DEPENDENCY_COUNT_FIELD));

    private final List<NeighborConnectionDetail> neighbors;

    private final String nextToken;

    private final Long knownDependencyCount;

    private ListServerNeighborsResponse(BuilderImpl builder) {
        super(builder);
        this.neighbors = builder.neighbors;
        this.nextToken = builder.nextToken;
        this.knownDependencyCount = builder.knownDependencyCount;
    }

    /**
     * Returns true if the Neighbors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasNeighbors() {
        return neighbors != null && !(neighbors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of distinct servers that are one hop away from the given server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasNeighbors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of distinct servers that are one hop away from the given server.
     */
    public List<NeighborConnectionDetail> neighbors() {
        return neighbors;
    }

    /**
     * <p>
     * Token to retrieve the next set of results. For example, if you specified 100 IDs for
     * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this token.
     * Use this token in the next query to retrieve the next set of 10.
     * </p>
     * 
     * @return Token to retrieve the next set of results. For example, if you specified 100 IDs for
     *         <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
     *         <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with
     *         this token. Use this token in the next query to retrieve the next set of 10.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Count of distinct servers that are one hop away from the given server.
     * </p>
     * 
     * @return Count of distinct servers that are one hop away from the given server.
     */
    public Long knownDependencyCount() {
        return knownDependencyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(neighbors());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(knownDependencyCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServerNeighborsResponse)) {
            return false;
        }
        ListServerNeighborsResponse other = (ListServerNeighborsResponse) obj;
        return Objects.equals(neighbors(), other.neighbors()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(knownDependencyCount(), other.knownDependencyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListServerNeighborsResponse").add("Neighbors", neighbors()).add("NextToken", nextToken())
                .add("KnownDependencyCount", knownDependencyCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "neighbors":
            return Optional.ofNullable(clazz.cast(neighbors()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "knownDependencyCount":
            return Optional.ofNullable(clazz.cast(knownDependencyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServerNeighborsResponse, T> g) {
        return obj -> g.apply((ListServerNeighborsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServerNeighborsResponse> {
        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param neighbors
         *        List of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighbors(Collection<NeighborConnectionDetail> neighbors);

        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param neighbors
         *        List of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neighbors(NeighborConnectionDetail... neighbors);

        /**
         * <p>
         * List of distinct servers that are one hop away from the given server.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NeighborConnectionDetail>.Builder} avoiding
         * the need to create one manually via {@link List<NeighborConnectionDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NeighborConnectionDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link #neighbors(List<NeighborConnectionDetail>)}.
         * 
         * @param neighbors
         *        a consumer that will call methods on {@link List<NeighborConnectionDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #neighbors(List<NeighborConnectionDetail>)
         */
        Builder neighbors(Consumer<NeighborConnectionDetail.Builder>... neighbors);

        /**
         * <p>
         * Token to retrieve the next set of results. For example, if you specified 100 IDs for
         * <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         * <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this
         * token. Use this token in the next query to retrieve the next set of 10.
         * </p>
         * 
         * @param nextToken
         *        Token to retrieve the next set of results. For example, if you specified 100 IDs for
         *        <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set
         *        <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with
         *        this token. Use this token in the next query to retrieve the next set of 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Count of distinct servers that are one hop away from the given server.
         * </p>
         * 
         * @param knownDependencyCount
         *        Count of distinct servers that are one hop away from the given server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knownDependencyCount(Long knownDependencyCount);
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private List<NeighborConnectionDetail> neighbors = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Long knownDependencyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServerNeighborsResponse model) {
            super(model);
            neighbors(model.neighbors);
            nextToken(model.nextToken);
            knownDependencyCount(model.knownDependencyCount);
        }

        public final Collection<NeighborConnectionDetail.Builder> getNeighbors() {
            return neighbors != null ? neighbors.stream().map(NeighborConnectionDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder neighbors(Collection<NeighborConnectionDetail> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copy(neighbors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighbors(NeighborConnectionDetail... neighbors) {
            neighbors(Arrays.asList(neighbors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neighbors(Consumer<NeighborConnectionDetail.Builder>... neighbors) {
            neighbors(Stream.of(neighbors).map(c -> NeighborConnectionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setNeighbors(Collection<NeighborConnectionDetail.BuilderImpl> neighbors) {
            this.neighbors = NeighborDetailsListCopier.copyFromBuilder(neighbors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Long getKnownDependencyCount() {
            return knownDependencyCount;
        }

        @Override
        public final Builder knownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
            return this;
        }

        public final void setKnownDependencyCount(Long knownDependencyCount) {
            this.knownDependencyCount = knownDependencyCount;
        }

        @Override
        public ListServerNeighborsResponse build() {
            return new ListServerNeighborsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
