/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDiscoverySummaryResponse extends ApplicationDiscoveryResponse implements
        ToCopyableBuilder<GetDiscoverySummaryResponse.Builder, GetDiscoverySummaryResponse> {
    private static final SdkField<Long> SERVERS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetDiscoverySummaryResponse::servers)).setter(setter(Builder::servers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("servers").build()).build();

    private static final SdkField<Long> APPLICATIONS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetDiscoverySummaryResponse::applications)).setter(setter(Builder::applications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applications").build()).build();

    private static final SdkField<Long> SERVERS_MAPPED_TO_APPLICATIONS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(GetDiscoverySummaryResponse::serversMappedToApplications))
            .setter(setter(Builder::serversMappedToApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedToApplications")
                    .build()).build();

    private static final SdkField<Long> SERVERS_MAPPEDTO_TAGS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(GetDiscoverySummaryResponse::serversMappedtoTags)).setter(setter(Builder::serversMappedtoTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serversMappedtoTags").build())
            .build();

    private static final SdkField<CustomerAgentInfo> AGENT_SUMMARY_FIELD = SdkField
            .<CustomerAgentInfo> builder(MarshallingType.SDK_POJO).getter(getter(GetDiscoverySummaryResponse::agentSummary))
            .setter(setter(Builder::agentSummary)).constructor(CustomerAgentInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentSummary").build()).build();

    private static final SdkField<CustomerConnectorInfo> CONNECTOR_SUMMARY_FIELD = SdkField
            .<CustomerConnectorInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDiscoverySummaryResponse::connectorSummary)).setter(setter(Builder::connectorSummary))
            .constructor(CustomerConnectorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVERS_FIELD,
            APPLICATIONS_FIELD, SERVERS_MAPPED_TO_APPLICATIONS_FIELD, SERVERS_MAPPEDTO_TAGS_FIELD, AGENT_SUMMARY_FIELD,
            CONNECTOR_SUMMARY_FIELD));

    private final Long servers;

    private final Long applications;

    private final Long serversMappedToApplications;

    private final Long serversMappedtoTags;

    private final CustomerAgentInfo agentSummary;

    private final CustomerConnectorInfo connectorSummary;

    private GetDiscoverySummaryResponse(BuilderImpl builder) {
        super(builder);
        this.servers = builder.servers;
        this.applications = builder.applications;
        this.serversMappedToApplications = builder.serversMappedToApplications;
        this.serversMappedtoTags = builder.serversMappedtoTags;
        this.agentSummary = builder.agentSummary;
        this.connectorSummary = builder.connectorSummary;
    }

    /**
     * <p>
     * The number of servers discovered.
     * </p>
     * 
     * @return The number of servers discovered.
     */
    public Long servers() {
        return servers;
    }

    /**
     * <p>
     * The number of applications discovered.
     * </p>
     * 
     * @return The number of applications discovered.
     */
    public Long applications() {
        return applications;
    }

    /**
     * <p>
     * The number of servers mapped to applications.
     * </p>
     * 
     * @return The number of servers mapped to applications.
     */
    public Long serversMappedToApplications() {
        return serversMappedToApplications;
    }

    /**
     * <p>
     * The number of servers mapped to tags.
     * </p>
     * 
     * @return The number of servers mapped to tags.
     */
    public Long serversMappedtoTags() {
        return serversMappedtoTags;
    }

    /**
     * <p>
     * Details about discovered agents, including agent status and health.
     * </p>
     * 
     * @return Details about discovered agents, including agent status and health.
     */
    public CustomerAgentInfo agentSummary() {
        return agentSummary;
    }

    /**
     * <p>
     * Details about discovered connectors, including connector status and health.
     * </p>
     * 
     * @return Details about discovered connectors, including connector status and health.
     */
    public CustomerConnectorInfo connectorSummary() {
        return connectorSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(servers());
        hashCode = 31 * hashCode + Objects.hashCode(applications());
        hashCode = 31 * hashCode + Objects.hashCode(serversMappedToApplications());
        hashCode = 31 * hashCode + Objects.hashCode(serversMappedtoTags());
        hashCode = 31 * hashCode + Objects.hashCode(agentSummary());
        hashCode = 31 * hashCode + Objects.hashCode(connectorSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDiscoverySummaryResponse)) {
            return false;
        }
        GetDiscoverySummaryResponse other = (GetDiscoverySummaryResponse) obj;
        return Objects.equals(servers(), other.servers()) && Objects.equals(applications(), other.applications())
                && Objects.equals(serversMappedToApplications(), other.serversMappedToApplications())
                && Objects.equals(serversMappedtoTags(), other.serversMappedtoTags())
                && Objects.equals(agentSummary(), other.agentSummary())
                && Objects.equals(connectorSummary(), other.connectorSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDiscoverySummaryResponse").add("Servers", servers()).add("Applications", applications())
                .add("ServersMappedToApplications", serversMappedToApplications())
                .add("ServersMappedtoTags", serversMappedtoTags()).add("AgentSummary", agentSummary())
                .add("ConnectorSummary", connectorSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "servers":
            return Optional.ofNullable(clazz.cast(servers()));
        case "applications":
            return Optional.ofNullable(clazz.cast(applications()));
        case "serversMappedToApplications":
            return Optional.ofNullable(clazz.cast(serversMappedToApplications()));
        case "serversMappedtoTags":
            return Optional.ofNullable(clazz.cast(serversMappedtoTags()));
        case "agentSummary":
            return Optional.ofNullable(clazz.cast(agentSummary()));
        case "connectorSummary":
            return Optional.ofNullable(clazz.cast(connectorSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDiscoverySummaryResponse, T> g) {
        return obj -> g.apply((GetDiscoverySummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationDiscoveryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDiscoverySummaryResponse> {
        /**
         * <p>
         * The number of servers discovered.
         * </p>
         * 
         * @param servers
         *        The number of servers discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Long servers);

        /**
         * <p>
         * The number of applications discovered.
         * </p>
         * 
         * @param applications
         *        The number of applications discovered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applications(Long applications);

        /**
         * <p>
         * The number of servers mapped to applications.
         * </p>
         * 
         * @param serversMappedToApplications
         *        The number of servers mapped to applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serversMappedToApplications(Long serversMappedToApplications);

        /**
         * <p>
         * The number of servers mapped to tags.
         * </p>
         * 
         * @param serversMappedtoTags
         *        The number of servers mapped to tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serversMappedtoTags(Long serversMappedtoTags);

        /**
         * <p>
         * Details about discovered agents, including agent status and health.
         * </p>
         * 
         * @param agentSummary
         *        Details about discovered agents, including agent status and health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentSummary(CustomerAgentInfo agentSummary);

        /**
         * <p>
         * Details about discovered agents, including agent status and health.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerAgentInfo.Builder} avoiding the need to
         * create one manually via {@link CustomerAgentInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerAgentInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #agentSummary(CustomerAgentInfo)}.
         * 
         * @param agentSummary
         *        a consumer that will call methods on {@link CustomerAgentInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentSummary(CustomerAgentInfo)
         */
        default Builder agentSummary(Consumer<CustomerAgentInfo.Builder> agentSummary) {
            return agentSummary(CustomerAgentInfo.builder().applyMutation(agentSummary).build());
        }

        /**
         * <p>
         * Details about discovered connectors, including connector status and health.
         * </p>
         * 
         * @param connectorSummary
         *        Details about discovered connectors, including connector status and health.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorSummary(CustomerConnectorInfo connectorSummary);

        /**
         * <p>
         * Details about discovered connectors, including connector status and health.
         * </p>
         * This is a convenience that creates an instance of the {@link CustomerConnectorInfo.Builder} avoiding the need
         * to create one manually via {@link CustomerConnectorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerConnectorInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #connectorSummary(CustomerConnectorInfo)}.
         * 
         * @param connectorSummary
         *        a consumer that will call methods on {@link CustomerConnectorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorSummary(CustomerConnectorInfo)
         */
        default Builder connectorSummary(Consumer<CustomerConnectorInfo.Builder> connectorSummary) {
            return connectorSummary(CustomerConnectorInfo.builder().applyMutation(connectorSummary).build());
        }
    }

    static final class BuilderImpl extends ApplicationDiscoveryResponse.BuilderImpl implements Builder {
        private Long servers;

        private Long applications;

        private Long serversMappedToApplications;

        private Long serversMappedtoTags;

        private CustomerAgentInfo agentSummary;

        private CustomerConnectorInfo connectorSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDiscoverySummaryResponse model) {
            super(model);
            servers(model.servers);
            applications(model.applications);
            serversMappedToApplications(model.serversMappedToApplications);
            serversMappedtoTags(model.serversMappedtoTags);
            agentSummary(model.agentSummary);
            connectorSummary(model.connectorSummary);
        }

        public final Long getServers() {
            return servers;
        }

        @Override
        public final Builder servers(Long servers) {
            this.servers = servers;
            return this;
        }

        public final void setServers(Long servers) {
            this.servers = servers;
        }

        public final Long getApplications() {
            return applications;
        }

        @Override
        public final Builder applications(Long applications) {
            this.applications = applications;
            return this;
        }

        public final void setApplications(Long applications) {
            this.applications = applications;
        }

        public final Long getServersMappedToApplications() {
            return serversMappedToApplications;
        }

        @Override
        public final Builder serversMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
            return this;
        }

        public final void setServersMappedToApplications(Long serversMappedToApplications) {
            this.serversMappedToApplications = serversMappedToApplications;
        }

        public final Long getServersMappedtoTags() {
            return serversMappedtoTags;
        }

        @Override
        public final Builder serversMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
            return this;
        }

        public final void setServersMappedtoTags(Long serversMappedtoTags) {
            this.serversMappedtoTags = serversMappedtoTags;
        }

        public final CustomerAgentInfo.Builder getAgentSummary() {
            return agentSummary != null ? agentSummary.toBuilder() : null;
        }

        @Override
        public final Builder agentSummary(CustomerAgentInfo agentSummary) {
            this.agentSummary = agentSummary;
            return this;
        }

        public final void setAgentSummary(CustomerAgentInfo.BuilderImpl agentSummary) {
            this.agentSummary = agentSummary != null ? agentSummary.build() : null;
        }

        public final CustomerConnectorInfo.Builder getConnectorSummary() {
            return connectorSummary != null ? connectorSummary.toBuilder() : null;
        }

        @Override
        public final Builder connectorSummary(CustomerConnectorInfo connectorSummary) {
            this.connectorSummary = connectorSummary;
            return this;
        }

        public final void setConnectorSummary(CustomerConnectorInfo.BuilderImpl connectorSummary) {
            this.connectorSummary = connectorSummary != null ? connectorSummary.build() : null;
        }

        @Override
        public GetDiscoverySummaryResponse build() {
            return new GetDiscoverySummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
