/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.applicationdiscovery.model.ApplicationDiscoveryRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormat;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportDataFormatsCopier;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFilter;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartExportTaskRequest
extends ApplicationDiscoveryRequest
implements ToCopyableBuilder<Builder, StartExportTaskRequest> {
    private static final SdkField<List<String>> EXPORT_DATA_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartExportTaskRequest.getter(StartExportTaskRequest::exportDataFormatAsStrings)).setter(StartExportTaskRequest.setter(Builder::exportDataFormatWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataFormat").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ExportFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StartExportTaskRequest.getter(StartExportTaskRequest::filters)).setter(StartExportTaskRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StartExportTaskRequest.getter(StartExportTaskRequest::startTime)).setter(StartExportTaskRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StartExportTaskRequest.getter(StartExportTaskRequest::endTime)).setter(StartExportTaskRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_DATA_FORMAT_FIELD, FILTERS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private final List<String> exportDataFormat;
    private final List<ExportFilter> filters;
    private final Instant startTime;
    private final Instant endTime;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.exportDataFormat = builder.exportDataFormat;
        this.filters = builder.filters;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public List<ExportDataFormat> exportDataFormat() {
        return ExportDataFormatsCopier.copyStringToEnum(this.exportDataFormat);
    }

    public List<String> exportDataFormatAsStrings() {
        return this.exportDataFormat;
    }

    public List<ExportFilter> filters() {
        return this.filters;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.exportDataFormatAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)((Object)obj);
        return Objects.equals(this.exportDataFormatAsStrings(), other.exportDataFormatAsStrings()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"StartExportTaskRequest").add("ExportDataFormat", this.exportDataFormatAsStrings()).add("Filters", this.filters()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "exportDataFormat": {
                return Optional.ofNullable(clazz.cast(this.exportDataFormatAsStrings()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationDiscoveryRequest.BuilderImpl
    implements Builder {
        private List<String> exportDataFormat = DefaultSdkAutoConstructList.getInstance();
        private List<ExportFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            this.exportDataFormatWithStrings(model.exportDataFormat);
            this.filters(model.filters);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final Collection<String> getExportDataFormatAsStrings() {
            return this.exportDataFormat;
        }

        @Override
        public final Builder exportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormatWithStrings(String ... exportDataFormat) {
            this.exportDataFormatWithStrings(Arrays.asList(exportDataFormat));
            return this;
        }

        @Override
        public final Builder exportDataFormat(Collection<ExportDataFormat> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copyEnumToString(exportDataFormat);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataFormat(ExportDataFormat ... exportDataFormat) {
            this.exportDataFormat(Arrays.asList(exportDataFormat));
            return this;
        }

        public final void setExportDataFormatWithStrings(Collection<String> exportDataFormat) {
            this.exportDataFormat = ExportDataFormatsCopier.copy(exportDataFormat);
        }

        public final Collection<ExportFilter.Builder> getFilters() {
            return this.filters != null ? (Collection)this.filters.stream().map(ExportFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ExportFilter> filters) {
            this.filters = ExportFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ExportFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ExportFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (ExportFilter)((ExportFilter.Builder)ExportFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ExportFilter.BuilderImpl> filters) {
            this.filters = ExportFiltersCopier.copyFromBuilder(filters);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartExportTaskRequest> {
        public Builder exportDataFormatWithStrings(Collection<String> var1);

        public Builder exportDataFormatWithStrings(String ... var1);

        public Builder exportDataFormat(Collection<ExportDataFormat> var1);

        public Builder exportDataFormat(ExportDataFormat ... var1);

        public Builder filters(Collection<ExportFilter> var1);

        public Builder filters(ExportFilter ... var1);

        public Builder filters(Consumer<ExportFilter.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

