/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.applicationcostprofiler.model.ApplicationCostProfilerResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinition;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReportDefinitionsResponse
extends ApplicationCostProfilerResponse
implements ToCopyableBuilder<Builder, ListReportDefinitionsResponse> {
    private static final SdkField<List<ReportDefinition>> REPORT_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("reportDefinitions").getter(ListReportDefinitionsResponse.getter(ListReportDefinitionsResponse::reportDefinitions)).setter(ListReportDefinitionsResponse.setter(Builder::reportDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReportDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReportDefinitionsResponse.getter(ListReportDefinitionsResponse::nextToken)).setter(ListReportDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListReportDefinitionsResponse.memberNameToFieldInitializer();
    private final List<ReportDefinition> reportDefinitions;
    private final String nextToken;

    private ListReportDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.reportDefinitions = builder.reportDefinitions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReportDefinitions() {
        return this.reportDefinitions != null && !(this.reportDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ReportDefinition> reportDefinitions() {
        return this.reportDefinitions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReportDefinitions() ? this.reportDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReportDefinitionsResponse)) {
            return false;
        }
        ListReportDefinitionsResponse other = (ListReportDefinitionsResponse)((Object)obj);
        return this.hasReportDefinitions() == other.hasReportDefinitions() && Objects.equals(this.reportDefinitions(), other.reportDefinitions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListReportDefinitionsResponse").add("ReportDefinitions", this.hasReportDefinitions() ? this.reportDefinitions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportDefinitions": {
                return Optional.ofNullable(clazz.cast(this.reportDefinitions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportDefinitions", REPORT_DEFINITIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListReportDefinitionsResponse, T> g) {
        return obj -> g.apply((ListReportDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationCostProfilerResponse.BuilderImpl
    implements Builder {
        private List<ReportDefinition> reportDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReportDefinitionsResponse model) {
            super(model);
            this.reportDefinitions(model.reportDefinitions);
            this.nextToken(model.nextToken);
        }

        public final List<ReportDefinition.Builder> getReportDefinitions() {
            List<ReportDefinition.Builder> result = ReportDefinitionListCopier.copyToBuilder(this.reportDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReportDefinitions(Collection<ReportDefinition.BuilderImpl> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copyFromBuilder(reportDefinitions);
        }

        @Override
        public final Builder reportDefinitions(Collection<ReportDefinition> reportDefinitions) {
            this.reportDefinitions = ReportDefinitionListCopier.copy(reportDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(ReportDefinition ... reportDefinitions) {
            this.reportDefinitions(Arrays.asList(reportDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportDefinitions(Consumer<ReportDefinition.Builder> ... reportDefinitions) {
            this.reportDefinitions(Stream.of(reportDefinitions).map(c -> (ReportDefinition)((ReportDefinition.Builder)ReportDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListReportDefinitionsResponse build() {
            return new ListReportDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ApplicationCostProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReportDefinitionsResponse> {
        public Builder reportDefinitions(Collection<ReportDefinition> var1);

        public Builder reportDefinitions(ReportDefinition ... var1);

        public Builder reportDefinitions(Consumer<ReportDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

