/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationcostprofiler.model.ApplicationCostProfilerResponse;
import software.amazon.awssdk.services.applicationcostprofiler.model.Format;
import software.amazon.awssdk.services.applicationcostprofiler.model.ReportFrequency;
import software.amazon.awssdk.services.applicationcostprofiler.model.S3Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReportDefinitionResponse
extends ApplicationCostProfilerResponse
implements ToCopyableBuilder<Builder, GetReportDefinitionResponse> {
    private static final SdkField<String> REPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportId").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::reportId)).setter(GetReportDefinitionResponse.setter(Builder::reportId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportId").build()}).build();
    private static final SdkField<String> REPORT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportDescription").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::reportDescription)).setter(GetReportDefinitionResponse.setter(Builder::reportDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportDescription").build()}).build();
    private static final SdkField<String> REPORT_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reportFrequency").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::reportFrequencyAsString)).setter(GetReportDefinitionResponse.setter(Builder::reportFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportFrequency").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::formatAsString)).setter(GetReportDefinitionResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<S3Location> DESTINATION_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationS3Location").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::destinationS3Location)).setter(GetReportDefinitionResponse.setter(Builder::destinationS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3Location").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::createdAt)).setter(GetReportDefinitionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdated").getter(GetReportDefinitionResponse.getter(GetReportDefinitionResponse::lastUpdated)).setter(GetReportDefinitionResponse.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ID_FIELD, REPORT_DESCRIPTION_FIELD, REPORT_FREQUENCY_FIELD, FORMAT_FIELD, DESTINATION_S3_LOCATION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_FIELD));
    private final String reportId;
    private final String reportDescription;
    private final String reportFrequency;
    private final String format;
    private final S3Location destinationS3Location;
    private final Instant createdAt;
    private final Instant lastUpdated;

    private GetReportDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.reportId = builder.reportId;
        this.reportDescription = builder.reportDescription;
        this.reportFrequency = builder.reportFrequency;
        this.format = builder.format;
        this.destinationS3Location = builder.destinationS3Location;
        this.createdAt = builder.createdAt;
        this.lastUpdated = builder.lastUpdated;
    }

    public final String reportId() {
        return this.reportId;
    }

    public final String reportDescription() {
        return this.reportDescription;
    }

    public final ReportFrequency reportFrequency() {
        return ReportFrequency.fromValue(this.reportFrequency);
    }

    public final String reportFrequencyAsString() {
        return this.reportFrequency;
    }

    public final Format format() {
        return Format.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final S3Location destinationS3Location() {
        return this.destinationS3Location;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reportId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReportDefinitionResponse)) {
            return false;
        }
        GetReportDefinitionResponse other = (GetReportDefinitionResponse)((Object)obj);
        return Objects.equals(this.reportId(), other.reportId()) && Objects.equals(this.reportDescription(), other.reportDescription()) && Objects.equals(this.reportFrequencyAsString(), other.reportFrequencyAsString()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.destinationS3Location(), other.destinationS3Location()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdated(), other.lastUpdated());
    }

    public final String toString() {
        return ToString.builder((String)"GetReportDefinitionResponse").add("ReportId", (Object)this.reportId()).add("ReportDescription", (Object)this.reportDescription()).add("ReportFrequency", (Object)this.reportFrequencyAsString()).add("Format", (Object)this.formatAsString()).add("DestinationS3Location", (Object)this.destinationS3Location()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdated", (Object)this.lastUpdated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "reportId": {
                return Optional.ofNullable(clazz.cast(this.reportId()));
            }
            case "reportDescription": {
                return Optional.ofNullable(clazz.cast(this.reportDescription()));
            }
            case "reportFrequency": {
                return Optional.ofNullable(clazz.cast(this.reportFrequencyAsString()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "destinationS3Location": {
                return Optional.ofNullable(clazz.cast(this.destinationS3Location()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReportDefinitionResponse, T> g) {
        return obj -> g.apply((GetReportDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApplicationCostProfilerResponse.BuilderImpl
    implements Builder {
        private String reportId;
        private String reportDescription;
        private String reportFrequency;
        private String format;
        private S3Location destinationS3Location;
        private Instant createdAt;
        private Instant lastUpdated;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReportDefinitionResponse model) {
            super(model);
            this.reportId(model.reportId);
            this.reportDescription(model.reportDescription);
            this.reportFrequency(model.reportFrequency);
            this.format(model.format);
            this.destinationS3Location(model.destinationS3Location);
            this.createdAt(model.createdAt);
            this.lastUpdated(model.lastUpdated);
        }

        public final String getReportId() {
            return this.reportId;
        }

        public final void setReportId(String reportId) {
            this.reportId = reportId;
        }

        @Override
        public final Builder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public final String getReportDescription() {
            return this.reportDescription;
        }

        public final void setReportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
        }

        @Override
        public final Builder reportDescription(String reportDescription) {
            this.reportDescription = reportDescription;
            return this;
        }

        public final String getReportFrequency() {
            return this.reportFrequency;
        }

        public final void setReportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
        }

        @Override
        public final Builder reportFrequency(String reportFrequency) {
            this.reportFrequency = reportFrequency;
            return this;
        }

        @Override
        public final Builder reportFrequency(ReportFrequency reportFrequency) {
            this.reportFrequency(reportFrequency == null ? null : reportFrequency.toString());
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final S3Location.Builder getDestinationS3Location() {
            return this.destinationS3Location != null ? this.destinationS3Location.toBuilder() : null;
        }

        public final void setDestinationS3Location(S3Location.BuilderImpl destinationS3Location) {
            this.destinationS3Location = destinationS3Location != null ? destinationS3Location.build() : null;
        }

        @Override
        public final Builder destinationS3Location(S3Location destinationS3Location) {
            this.destinationS3Location = destinationS3Location;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        @Override
        public GetReportDefinitionResponse build() {
            return new GetReportDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApplicationCostProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReportDefinitionResponse> {
        public Builder reportId(String var1);

        public Builder reportDescription(String var1);

        public Builder reportFrequency(String var1);

        public Builder reportFrequency(ReportFrequency var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder destinationS3Location(S3Location var1);

        default public Builder destinationS3Location(Consumer<S3Location.Builder> destinationS3Location) {
            return this.destinationS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(destinationS3Location)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder lastUpdated(Instant var1);
    }
}

