/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3BucketRegion {
    AP_EAST_1("ap-east-1"),
    ME_SOUTH_1("me-south-1"),
    EU_SOUTH_1("eu-south-1"),
    AF_SOUTH_1("af-south-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3BucketRegion> VALUE_MAP;
    private final String value;

    private S3BucketRegion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3BucketRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3BucketRegion> knownValues() {
        EnumSet<S3BucketRegion> knownValues = EnumSet.allOf(S3BucketRegion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3BucketRegion.class, S3BucketRegion::toString);
    }
}

