/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationcostprofiler.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReportFrequency {
    MONTHLY("MONTHLY"),
    DAILY("DAILY"),
    ALL("ALL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReportFrequency(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReportFrequency fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReportFrequency.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReportFrequency> knownValues() {
        return Stream.of(ReportFrequency.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

