/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a predefined metric for a target tracking scaling policy to use with Application Auto Scaling.
 * </p>
 * <p>
 * For more information, <a
 * href="https://docs.aws.amazon.com/autoscaling/application/userguide/monitoring-cloudwatch.html#predefined-metrics"
 * >Predefined metrics for target tracking scaling policies</a> in the <i>Application Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedMetricSpecification.Builder, PredefinedMetricSpecification> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredefinedMetricType").getter(getter(PredefinedMetricSpecification::predefinedMetricTypeAsString))
            .setter(setter(Builder::predefinedMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build())
            .build();

    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceLabel").getter(getter(PredefinedMetricSpecification::resourceLabel))
            .setter(setter(Builder::resourceLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD,
            RESOURCE_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String predefinedMetricType;

    private final String resourceLabel;

    private PredefinedMetricSpecification(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    /**
     * <p>
     * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and ECS
     * services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and
     *         ECS services.
     * @see MetricType
     */
    public final MetricType predefinedMetricType() {
        return MetricType.fromValue(predefinedMetricType);
    }

    /**
     * <p>
     * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and ECS
     * services.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and
     *         ECS services.
     * @see MetricType
     */
    public final String predefinedMetricTypeAsString() {
        return predefinedMetricType;
    }

    /**
     * <p>
     * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
     * type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS
     * service.
     * </p>
     * <p>
     * You create the resource label by appending the final portion of the load balancer ARN and the final portion of
     * the target group ARN into a single value, separated by a forward slash (/). The format of the resource label is:
     * </p>
     * <p>
     * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.
     * </p>
     * <p>
     * Where:
     * </p>
     * <ul>
     * <li>
     * <p>
     * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     * </p>
     * </li>
     * <li>
     * <p>
     * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To find the ARN for an Application Load Balancer, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     * >DescribeTargetGroups</a> API operation.
     * </p>
     * 
     * @return Identifies the resource associated with the metric type. You can't specify a resource label unless the
     *         metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot
     *         Fleet or ECS service.</p>
     *         <p>
     *         You create the resource label by appending the final portion of the load balancer ARN and the final
     *         portion of the target group ARN into a single value, separated by a forward slash (/). The format of the
     *         resource label is:
     *         </p>
     *         <p>
     *         <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.
     *         </p>
     *         <p>
     *         Where:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
     *         ARN.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To find the ARN for an Application Load Balancer, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
     *         >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
     *         >DescribeTargetGroups</a> API operation.
     */
    public final String resourceLabel() {
        return resourceLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedMetricSpecification)) {
            return false;
        }
        PredefinedMetricSpecification other = (PredefinedMetricSpecification) obj;
        return Objects.equals(predefinedMetricTypeAsString(), other.predefinedMetricTypeAsString())
                && Objects.equals(resourceLabel(), other.resourceLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredefinedMetricSpecification").add("PredefinedMetricType", predefinedMetricTypeAsString())
                .add("ResourceLabel", resourceLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricType":
            return Optional.ofNullable(clazz.cast(predefinedMetricTypeAsString()));
        case "ResourceLabel":
            return Optional.ofNullable(clazz.cast(resourceLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PredefinedMetricType", PREDEFINED_METRIC_TYPE_FIELD);
        map.put("ResourceLabel", RESOURCE_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PredefinedMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedMetricSpecification> {
        /**
         * <p>
         * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and ECS
         * services.
         * </p>
         * 
         * @param predefinedMetricType
         *        The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and
         *        ECS services.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder predefinedMetricType(String predefinedMetricType);

        /**
         * <p>
         * The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and ECS
         * services.
         * </p>
         * 
         * @param predefinedMetricType
         *        The metric type. The <code>ALBRequestCountPerTarget</code> metric type applies only to Spot Fleets and
         *        ECS services.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder predefinedMetricType(MetricType predefinedMetricType);

        /**
         * <p>
         * Identifies the resource associated with the metric type. You can't specify a resource label unless the metric
         * type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot Fleet or ECS
         * service.
         * </p>
         * <p>
         * You create the resource label by appending the final portion of the load balancer ARN and the final portion
         * of the target group ARN into a single value, separated by a forward slash (/). The format of the resource
         * label is:
         * </p>
         * <p>
         * <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.
         * </p>
         * <p>
         * Where:
         * </p>
         * <ul>
         * <li>
         * <p>
         * app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         * </p>
         * </li>
         * <li>
         * <p>
         * targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group ARN.
         * </p>
         * </li>
         * </ul>
         * <p>
         * To find the ARN for an Application Load Balancer, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         * >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a
         * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         * >DescribeTargetGroups</a> API operation.
         * </p>
         * 
         * @param resourceLabel
         *        Identifies the resource associated with the metric type. You can't specify a resource label unless the
         *        metric type is <code>ALBRequestCountPerTarget</code> and there is a target group attached to the Spot
         *        Fleet or ECS service.</p>
         *        <p>
         *        You create the resource label by appending the final portion of the load balancer ARN and the final
         *        portion of the target group ARN into a single value, separated by a forward slash (/). The format of
         *        the resource label is:
         *        </p>
         *        <p>
         *        <code>app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff</code>.
         *        </p>
         *        <p>
         *        Where:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        app/&lt;load-balancer-name&gt;/&lt;load-balancer-id&gt; is the final portion of the load balancer ARN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        targetgroup/&lt;target-group-name&gt;/&lt;target-group-id&gt; is the final portion of the target group
         *        ARN.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To find the ARN for an Application Load Balancer, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html"
         *        >DescribeLoadBalancers</a> API operation. To find the ARN for the target group, use the <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html"
         *        >DescribeTargetGroups</a> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLabel(String resourceLabel);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedMetricType;

        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedMetricSpecification model) {
            predefinedMetricType(model.predefinedMetricType);
            resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedMetricType() {
            return predefinedMetricType;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public final Builder predefinedMetricType(MetricType predefinedMetricType) {
            this.predefinedMetricType(predefinedMetricType == null ? null : predefinedMetricType.toString());
            return this;
        }

        public final String getResourceLabel() {
            return resourceLabel;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        @Override
        public PredefinedMetricSpecification build() {
            return new PredefinedMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
