/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the reason for an activity that isn't scaled (<i>not scaled activity</i>), in machine-readable format. For
 * help interpreting the not scaled reason details, see <a href=
 * "https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-scaling-activities.html"
 * >Scaling activities for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotScaledReason implements SdkPojo, Serializable, ToCopyableBuilder<NotScaledReason.Builder, NotScaledReason> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(NotScaledReason::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(NotScaledReason::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(NotScaledReason::minCapacity)).setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> CURRENT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentCapacity").getter(getter(NotScaledReason::currentCapacity))
            .setter(setter(Builder::currentCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD,
            MAX_CAPACITY_FIELD, MIN_CAPACITY_FIELD, CURRENT_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final Integer maxCapacity;

    private final Integer minCapacity;

    private final Integer currentCapacity;

    private NotScaledReason(BuilderImpl builder) {
        this.code = builder.code;
        this.maxCapacity = builder.maxCapacity;
        this.minCapacity = builder.minCapacity;
        this.currentCapacity = builder.currentCapacity;
    }

    /**
     * <p>
     * A code that represents the reason for not scaling.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AutoScalingAnticipatedFlapping
     * </p>
     * </li>
     * <li>
     * <p>
     * TargetServicePutResourceAsUnscalable
     * </p>
     * </li>
     * <li>
     * <p>
     * AlreadyAtMaxCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * AlreadyAtMinCapacity
     * </p>
     * </li>
     * <li>
     * <p>
     * AlreadyAtDesiredCapacity
     * </p>
     * </li>
     * </ul>
     * 
     * @return A code that represents the reason for not scaling.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AutoScalingAnticipatedFlapping
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TargetServicePutResourceAsUnscalable
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AlreadyAtMaxCapacity
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AlreadyAtMinCapacity
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AlreadyAtDesiredCapacity
     *         </p>
     *         </li>
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * The maximum capacity.
     * </p>
     * 
     * @return The maximum capacity.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The minimum capacity.
     * </p>
     * 
     * @return The minimum capacity.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The current capacity.
     * </p>
     * 
     * @return The current capacity.
     */
    public final Integer currentCapacity() {
        return currentCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(currentCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotScaledReason)) {
            return false;
        }
        NotScaledReason other = (NotScaledReason) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(minCapacity(), other.minCapacity())
                && Objects.equals(currentCapacity(), other.currentCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotScaledReason").add("Code", code()).add("MaxCapacity", maxCapacity())
                .add("MinCapacity", minCapacity()).add("CurrentCapacity", currentCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "CurrentCapacity":
            return Optional.ofNullable(clazz.cast(currentCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("CurrentCapacity", CURRENT_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotScaledReason, T> g) {
        return obj -> g.apply((NotScaledReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotScaledReason> {
        /**
         * <p>
         * A code that represents the reason for not scaling.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AutoScalingAnticipatedFlapping
         * </p>
         * </li>
         * <li>
         * <p>
         * TargetServicePutResourceAsUnscalable
         * </p>
         * </li>
         * <li>
         * <p>
         * AlreadyAtMaxCapacity
         * </p>
         * </li>
         * <li>
         * <p>
         * AlreadyAtMinCapacity
         * </p>
         * </li>
         * <li>
         * <p>
         * AlreadyAtDesiredCapacity
         * </p>
         * </li>
         * </ul>
         * 
         * @param code
         *        A code that represents the reason for not scaling.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AutoScalingAnticipatedFlapping
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TargetServicePutResourceAsUnscalable
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AlreadyAtMaxCapacity
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AlreadyAtMinCapacity
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AlreadyAtDesiredCapacity
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * The maximum capacity.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The minimum capacity.
         * </p>
         * 
         * @param minCapacity
         *        The minimum capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The current capacity.
         * </p>
         * 
         * @param currentCapacity
         *        The current capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCapacity(Integer currentCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private Integer maxCapacity;

        private Integer minCapacity;

        private Integer currentCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(NotScaledReason model) {
            code(model.code);
            maxCapacity(model.maxCapacity);
            minCapacity(model.minCapacity);
            currentCapacity(model.currentCapacity);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getCurrentCapacity() {
            return currentCapacity;
        }

        public final void setCurrentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
        }

        @Override
        public final Builder currentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
            return this;
        }

        @Override
        public NotScaledReason build() {
            return new NotScaledReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
