/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledActionsResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<DescribeScheduledActionsResponse.Builder, DescribeScheduledActionsResponse> {
    private static final SdkField<List<ScheduledAction>> SCHEDULED_ACTIONS_FIELD = SdkField
            .<List<ScheduledAction>> builder(MarshallingType.LIST)
            .memberName("ScheduledActions")
            .getter(getter(DescribeScheduledActionsResponse::scheduledActions))
            .setter(setter(Builder::scheduledActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeScheduledActionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScheduledAction> scheduledActions;

    private final String nextToken;

    private DescribeScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActions = builder.scheduledActions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduledActions() {
        return scheduledActions != null && !(scheduledActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the scheduled actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledActions} method.
     * </p>
     * 
     * @return Information about the scheduled actions.
     */
    public final List<ScheduledAction> scheduledActions() {
        return scheduledActions;
    }

    /**
     * <p>
     * The token required to get the next set of results. This value is <code>null</code> if there are no more results
     * to return.
     * </p>
     * 
     * @return The token required to get the next set of results. This value is <code>null</code> if there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledActions() ? scheduledActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsResponse)) {
            return false;
        }
        DescribeScheduledActionsResponse other = (DescribeScheduledActionsResponse) obj;
        return hasScheduledActions() == other.hasScheduledActions()
                && Objects.equals(scheduledActions(), other.scheduledActions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduledActionsResponse")
                .add("ScheduledActions", hasScheduledActions() ? scheduledActions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActions":
            return Optional.ofNullable(clazz.cast(scheduledActions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledActions", SCHEDULED_ACTIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsResponse, T> g) {
        return obj -> g.apply((DescribeScheduledActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledActionsResponse> {
        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        Information about the scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(Collection<ScheduledAction> scheduledActions);

        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * 
         * @param scheduledActions
         *        Information about the scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(ScheduledAction... scheduledActions);

        /**
         * <p>
         * Information about the scheduled actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction.Builder#build()} is
         * called immediately and its result is passed to {@link #scheduledActions(List<ScheduledAction>)}.
         * 
         * @param scheduledActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.applicationautoscaling.model.ScheduledAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledActions(java.util.Collection<ScheduledAction>)
         */
        Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions);

        /**
         * <p>
         * The token required to get the next set of results. This value is <code>null</code> if there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token required to get the next set of results. This value is <code>null</code> if there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private List<ScheduledAction> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsResponse model) {
            super(model);
            scheduledActions(model.scheduledActions);
            nextToken(model.nextToken);
        }

        public final List<ScheduledAction.Builder> getScheduledActions() {
            List<ScheduledAction.Builder> result = ScheduledActionsCopier.copyToBuilder(this.scheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledActions(Collection<ScheduledAction.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledAction> scheduledActions) {
            this.scheduledActions = ScheduledActionsCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledAction... scheduledActions) {
            scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledAction.Builder>... scheduledActions) {
            scheduledActions(Stream.of(scheduledActions).map(c -> ScheduledAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeScheduledActionsResponse build() {
            return new DescribeScheduledActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
