/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse;

public class ListEventIntegrationAssociationsPublisher
implements SdkPublisher<ListEventIntegrationAssociationsResponse> {
    private final AppIntegrationsAsyncClient client;
    private final ListEventIntegrationAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventIntegrationAssociationsPublisher(AppIntegrationsAsyncClient client, ListEventIntegrationAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventIntegrationAssociationsPublisher(AppIntegrationsAsyncClient client, ListEventIntegrationAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventIntegrationAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventIntegrationAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventIntegrationAssociation> eventIntegrationAssociations() {
        Function<ListEventIntegrationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventIntegrationAssociations() != null) {
                return response.eventIntegrationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventIntegrationAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventIntegrationAssociationsResponseFetcher
    implements AsyncPageFetcher<ListEventIntegrationAssociationsResponse> {
        private ListEventIntegrationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventIntegrationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventIntegrationAssociationsResponse> nextPage(ListEventIntegrationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventIntegrationAssociationsPublisher.this.client.listEventIntegrationAssociations(ListEventIntegrationAssociationsPublisher.this.firstRequest);
            }
            return ListEventIntegrationAssociationsPublisher.this.client.listEventIntegrationAssociations((ListEventIntegrationAssociationsRequest)((Object)ListEventIntegrationAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

