/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.ApplicationAssociationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationAssociationsResponse;

public class ListApplicationAssociationsPublisher
implements SdkPublisher<ListApplicationAssociationsResponse> {
    private final AppIntegrationsAsyncClient client;
    private final ListApplicationAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationAssociationsPublisher(AppIntegrationsAsyncClient client, ListApplicationAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationAssociationsPublisher(AppIntegrationsAsyncClient client, ListApplicationAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationAssociationSummary> applicationAssociations() {
        Function<ListApplicationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssociations() != null) {
                return response.applicationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationAssociationsResponseFetcher
    implements AsyncPageFetcher<ListApplicationAssociationsResponse> {
        private ListApplicationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationAssociationsResponse> nextPage(ListApplicationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssociationsPublisher.this.client.listApplicationAssociations(ListApplicationAssociationsPublisher.this.firstRequest);
            }
            return ListApplicationAssociationsPublisher.this.client.listApplicationAssociations((ListApplicationAssociationsRequest)((Object)ListApplicationAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

