/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appintegrations.AppIntegrationsClient;
import software.amazon.awssdk.services.appintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.appintegrations.model.ApplicationAssociationSummary;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListApplicationAssociationsResponse;

public class ListApplicationAssociationsIterable
implements SdkIterable<ListApplicationAssociationsResponse> {
    private final AppIntegrationsClient client;
    private final ListApplicationAssociationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationAssociationsIterable(AppIntegrationsClient client, ListApplicationAssociationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationAssociationsResponseFetcher();
    }

    public Iterator<ListApplicationAssociationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApplicationAssociationSummary> applicationAssociations() {
        Function<ListApplicationAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationAssociations() != null) {
                return response.applicationAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationAssociationsResponseFetcher
    implements SyncPageFetcher<ListApplicationAssociationsResponse> {
        private ListApplicationAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationAssociationsResponse nextPage(ListApplicationAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAssociationsIterable.this.client.listApplicationAssociations(ListApplicationAssociationsIterable.this.firstRequest);
            }
            return ListApplicationAssociationsIterable.this.client.listApplicationAssociations((ListApplicationAssociationsRequest)((Object)ListApplicationAssociationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

